/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.validation.XAdESCertificateRefExtractionUtils;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESCertificateSource.class);
    private final Element signatureElement;
    private final XAdESPaths xadesPaths;

    public XAdESCertificateSource(Element signatureElement, XAdESPaths xadesPaths) {
        Objects.requireNonNull(signatureElement, "Element signature must not be null");
        Objects.requireNonNull(xadesPaths, "XAdESPaths must not be null");
        this.signatureElement = signatureElement;
        this.xadesPaths = xadesPaths;
        this.extractCertificates(XMLDSigPaths.KEY_INFO_X509_CERTIFICATE_PATH, CertificateOrigin.KEY_INFO);
        this.extractCertificates(xadesPaths.getEncapsulatedCertificateValuesPath(), CertificateOrigin.CERTIFICATE_VALUES);
        this.extractCertificates(xadesPaths.getEncapsulatedAttrAuthoritiesCertValuesPath(), CertificateOrigin.ATTR_AUTORITIES_CERT_VALUES);
        this.extractCertificates(xadesPaths.getEncapsulatedTimeStampValidationDataCertValuesPath(), CertificateOrigin.TIMESTAMP_VALIDATION_DATA);
        this.extractCertificateRefs(xadesPaths.getSigningCertificatePath(), xadesPaths.getSigningCertificateV2Path(), CertificateRefOrigin.SIGNING_CERTIFICATE);
        this.extractCertificateRefs(xadesPaths.getCompleteCertificateRefsCertPath(), xadesPaths.getCompleteCertificateRefsV2CertPath(), CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
        this.extractCertificateRefs(xadesPaths.getAttributeCertificateRefsCertPath(), xadesPaths.getAttributeCertificateRefsV2CertPath(), CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
        if (LOG.isInfoEnabled()) {
            LOG.info("+XAdESCertificateSource");
        }
    }

    private void extractCertificates(String xPathQuery, CertificateOrigin origin) {
        if (xPathQuery == null) {
            return;
        }
        NodeList nodeList = DomUtils.getNodeList(this.signatureElement, xPathQuery);
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            Element certificateElement = (Element)nodeList.item(ii);
            try {
                byte[] derEncoded = Utils.fromBase64(certificateElement.getTextContent());
                CertificateToken cert = DSSUtils.loadCertificate(derEncoded);
                this.addCertificate(cert, origin);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Unable to parse certificate '{}' : {}", (Object)certificateElement.getTextContent(), (Object)e.getMessage());
            }
        }
    }

    private void extractCertificateRefs(String xpathV1, String xpathV2, CertificateRefOrigin origin) {
        NodeList certRefNodeList;
        if (xpathV1 != null && (certRefNodeList = DomUtils.getNodeList(this.signatureElement, xpathV1)) != null) {
            this.extractXAdESCertsV1(certRefNodeList, origin);
        }
        if (xpathV2 != null && (certRefNodeList = DomUtils.getNodeList(this.signatureElement, xpathV2)) != null) {
            this.extractXAdESCertsV2(certRefNodeList, origin);
        }
    }

    private void extractXAdESCertsV1(NodeList certNodeList, CertificateRefOrigin origin) {
        for (int i = 0; i < certNodeList.getLength(); ++i) {
            Element certRefElement = (Element)certNodeList.item(i);
            CertificateRef certificateRef = XAdESCertificateRefExtractionUtils.createCertificateRefFromV1(certRefElement, this.xadesPaths);
            if (certificateRef == null) continue;
            certificateRef.setOrigin(origin);
            this.addCertificateRef(certificateRef, origin);
        }
    }

    private void extractXAdESCertsV2(NodeList certNodeList, CertificateRefOrigin origin) {
        for (int i = 0; i < certNodeList.getLength(); ++i) {
            Element certRefElement = (Element)certNodeList.item(i);
            CertificateRef certificateRef = XAdESCertificateRefExtractionUtils.createCertificateRefFromV2(certRefElement, this.xadesPaths);
            if (certificateRef == null) continue;
            certificateRef.setOrigin(origin);
            this.addCertificateRef(certificateRef, origin);
        }
    }

    @Override
    protected CandidatesForSigningCertificate extractCandidatesForSigningCertificate(CertificateToken providedSigningCertificateToken) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        for (CertificateToken certificateToken : this.getKeyInfoCertificates()) {
            candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
        }
        if (candidatesForSigningCertificate.isEmpty()) {
            PublicKey publicKey = DSSXMLUtils.getKeyInfoSigningCertificatePublicKey(this.signatureElement);
            if (publicKey != null) {
                Set<CertificateToken> certsByPublicKey = this.getByPublicKey(publicKey);
                if (Utils.isCollectionNotEmpty(certsByPublicKey)) {
                    for (CertificateToken certificateToken : certsByPublicKey) {
                        candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
                    }
                } else {
                    candidatesForSigningCertificate.add(new CertificateValidity(publicKey));
                }
            } else {
                for (CertificateToken certificateToken : this.getCertificates()) {
                    candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
                }
            }
        }
        if (providedSigningCertificateToken != null) {
            candidatesForSigningCertificate.add(new CertificateValidity(providedSigningCertificateToken));
        }
        this.checkCandidatesAgainstSigningCertificateRef(candidatesForSigningCertificate);
        return candidatesForSigningCertificate;
    }

    private void checkCandidatesAgainstSigningCertificateRef(CandidatesForSigningCertificate candidates) {
        List<CertificateRef> potentialSigningCertificates = this.getSigningCertificateRefs();
        if (Utils.isCollectionNotEmpty(potentialSigningCertificates)) {
            CertificateRef signingCert = potentialSigningCertificates.get(0);
            CertificateTokenRefMatcher matcher = new CertificateTokenRefMatcher();
            CertificateValidity bestCertificateValidity = null;
            List<CertificateValidity> certificateValidityList = candidates.getCertificateValidityList();
            for (CertificateValidity certificateValidity : certificateValidityList) {
                certificateValidity.setDigestPresent(signingCert.getCertDigest() != null);
                certificateValidity.setIssuerSerialPresent(signingCert.getCertificateIdentifier() != null);
                CertificateToken certificateToken = certificateValidity.getCertificateToken();
                if (certificateToken != null) {
                    certificateValidity.setDigestEqual(matcher.matchByDigest(certificateToken, signingCert));
                    certificateValidity.setSerialNumberEqual(matcher.matchBySerialNumber(certificateToken, signingCert));
                    certificateValidity.setDistinguishedNameEqual(matcher.matchByIssuerName(certificateToken, signingCert));
                }
                if (!certificateValidity.isValid()) continue;
                bestCertificateValidity = certificateValidity;
            }
            if (bestCertificateValidity == null && !candidates.isEmpty()) {
                bestCertificateValidity = candidates.getCertificateValidityList().iterator().next();
            }
            if (bestCertificateValidity != null) {
                candidates.setTheCertificateValidity(bestCertificateValidity);
            }
        }
    }
}

