/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.ObjectIdentifierQualifier;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.InternallyDetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected DSSDocument detachedDocument;
    protected String keyInfoCanonicalizationMethod;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected final String deterministicId;
    protected Element signatureDom;
    protected Element keyInfoDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected static final String KEYINFO_SUFFIX = "keyInfo-";
    protected static final String TIMESTAMP_SUFFIX = "TS-";
    protected static final String VALUE_SUFFIX = "value-";
    protected static final String XADES_SUFFIX = "xades-";
    protected static final String OBJECT_ID_SUFFIX = "o-";
    protected static final String REFERENCE_ID_SUFFIX = "r-";

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(params.getSignaturePackaging(), "Cannot create a SignatureBuilder. SignaturePackaging is not defined!");
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, document, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, document, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, document, certificateVerifier);
            }
            case INTERNALLY_DETACHED: {
                return new InternallyDetachedSignatureBuilder(params, document, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + (Object)((Object)params.getSignaturePackaging()));
    }

    public XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument detachedDocument, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.detachedDocument = detachedDocument;
        this.deterministicId = params.getDeterministicId();
        this.setCanonicalizationMethods(params);
    }

    private void setCanonicalizationMethods(XAdESSignatureParameters params) {
        this.keyInfoCanonicalizationMethod = params.getKeyInfoCanonicalizationMethod();
        this.signedInfoCanonicalizationMethod = params.getSignedInfoCanonicalizationMethod();
        this.signedPropertiesCanonicalizationMethod = params.getSignedPropertiesCanonicalizationMethod();
    }

    public byte[] build() throws DSSException {
        this.ensureConfigurationValidity();
        this.xadesPaths = this.getCurrentXAdESPaths();
        this.documentDom = this.buildRootDocumentDom();
        this.incorporateFiles();
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObject();
        if (Utils.isArrayEmpty(this.params.getSignedData())) {
            this.incorporateReferences();
            this.incorporateReferenceSignedProperties();
            this.incorporateReferenceKeyInfo();
        }
        byte[] canonicalizedSignedInfo = DSSXMLUtils.canonicalizeSubtree(this.signedInfoCanonicalizationMethod, this.getNodeToCanonicalize(this.signedInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA256, canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Utils.toBase64(digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    private void ensureConfigurationValidity() {
        this.checkSignaturePackagingValidity();
        List<DSSReference> references = this.params.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            List<DSSReference> defaultReferences = this.createDefaultReferences();
            this.params.setReferences(defaultReferences);
        } else {
            this.checkReferencesValidity();
        }
    }

    private void checkSignaturePackagingValidity() {
        if (!SignaturePackaging.ENVELOPING.equals((Object)this.params.getSignaturePackaging())) {
            if (this.params.isManifestSignature()) {
                throw new DSSException(String.format("The signature packaging %s is not compatible with manifestSignature(true) configuration!", new Object[]{this.params.getSignaturePackaging()}));
            }
            if (this.params.isEmbedXML()) {
                throw new DSSException(String.format("The signature packaging %s is not compatible with embedXML(true) configuration!", new Object[]{this.params.getSignaturePackaging()}));
            }
        }
    }

    private void checkReferencesValidity() {
        String referenceWrongMessage = "Reference setting is not correct! ";
        for (DSSReference reference : this.params.getReferences()) {
            List<DSSTransform> transforms = reference.getTransforms();
            if (Utils.isCollectionNotEmpty(transforms)) {
                boolean incorrectUsageOfEnvelopedSignature = false;
                for (DSSTransform transform : transforms) {
                    switch (transform.getAlgorithm()) {
                        case "http://www.w3.org/2000/09/xmldsig#base64": {
                            if (this.params.isEmbedXML()) {
                                throw new DSSException(referenceWrongMessage + "The embedXML(true) parameter is not compatible with base64 transform.");
                            }
                            if (this.params.isManifestSignature()) {
                                throw new DSSException(referenceWrongMessage + "Manifest signature is not compatible with base64 transform.");
                            }
                            if (!SignaturePackaging.ENVELOPING.equals((Object)this.params.getSignaturePackaging())) {
                                throw new DSSException(referenceWrongMessage + String.format("Base64 transform is not compatible with %s signature format.", new Object[]{this.params.getSignaturePackaging()}));
                            }
                            if (transforms.size() <= 1) break;
                            throw new DSSException(referenceWrongMessage + "Base64 transform cannot be used with other transformations.");
                        }
                        case "http://www.w3.org/2000/09/xmldsig#enveloped-signature": {
                            incorrectUsageOfEnvelopedSignature = true;
                            break;
                        }
                        case "http://www.w3.org/2006/12/xml-c14n11": 
                        case "http://www.w3.org/2006/12/xml-c14n11#WithComments": 
                        case "http://www.w3.org/2001/10/xml-exc-c14n#": 
                        case "http://www.w3.org/2001/10/xml-exc-c14n#WithComments": 
                        case "http://www.w3.org/TR/2001/REC-xml-c14n-20010315": 
                        case "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments": {
                            incorrectUsageOfEnvelopedSignature = false;
                            break;
                        }
                    }
                }
                if (!incorrectUsageOfEnvelopedSignature) continue;
                throw new DSSException(referenceWrongMessage + "Enveloped Signature Transform must be followed up by a Canonicalization Transform.");
            }
            String uri = reference.getUri();
            if (Utils.isStringBlank(uri) || DomUtils.isElementReference(uri)) {
                LOG.warn("A reference with id='{}' and uri='{}' points to an XML Node, while no transforms are defined! The configuration can lead to an unexpected result!", (Object)reference.getId(), (Object)uri);
            }
            if (!SignaturePackaging.ENVELOPED.equals((Object)this.params.getSignaturePackaging()) || !Utils.isStringBlank(uri)) continue;
            throw new DSSException(referenceWrongMessage + "Enveloped signature must have an enveloped transformation!");
        }
    }

    protected void incorporateFiles() {
    }

    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNATURE);
        DomUtils.addNamespaceAttribute(this.signatureDom, this.getXmldsigNamespace());
        this.signatureDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        this.incorporateSignatureDom(parentNodeOfSignature);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    protected void incorporateSignatureDom(Node parentNodeOfSignature) {
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    public void incorporateSignedInfo() {
        if (Utils.isArrayNotEmpty(this.params.getSignedData())) {
            LOG.debug("Using explict SignedInfo from parameter");
            this.signedInfoDom = DomUtils.buildDOM(this.params.getSignedData()).getDocumentElement();
            this.signedInfoDom = (Element)this.documentDom.importNode(this.signedInfoDom, true);
            this.signatureDom.appendChild(this.signedInfoDom);
            return;
        }
        this.signedInfoDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNED_INFO);
        this.signatureDom.appendChild(this.signedInfoDom);
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNATURE_METHOD);
        this.signedInfoDom.appendChild(signatureMethod);
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        MaskGenerationFunction mgf = this.params.getMaskGenerationFunction();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, mgf);
        String signatureAlgorithmXMLId = signatureAlgorithm.getUri();
        if (Utils.isStringBlank(signatureAlgorithmXMLId)) {
            throw new DSSException("Unsupported signature algorithm " + signatureAlgorithm);
        }
        signatureMethod.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.CANONICALIZATION_METHOD);
        parentDom.appendChild(canonicalizationMethodDom);
        canonicalizationMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            this.incorporateReference(reference);
        }
    }

    protected void incorporateKeyInfo() throws DSSException {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signature DOM later");
            return;
        }
        Element keyInfoDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.KEY_INFO);
        this.signatureDom.appendChild(keyInfoDom);
        if (this.params.isSignKeyInfo()) {
            keyInfoDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), KEYINFO_SUFFIX + this.deterministicId);
        }
        BaselineBCertificateSelector certSelector = new BaselineBCertificateSelector(this.certificateVerifier, this.params);
        List<CertificateToken> certificates = certSelector.getCertificates();
        if (this.params.isAddX509SubjectName()) {
            for (CertificateToken token : certificates) {
                Element x509DataDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.X509_DATA);
                keyInfoDom.appendChild(x509DataDom);
                this.addSubjectAndCertificate(x509DataDom, token);
            }
        } else {
            Element x509DataDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.X509_DATA);
            keyInfoDom.appendChild(x509DataDom);
            for (CertificateToken token : certificates) {
                this.addCertificate(x509DataDom, token);
            }
        }
        this.keyInfoDom = keyInfoDom;
    }

    private void addSubjectAndCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, this.getXmldsigNamespace(), XMLDSigElement.X509_SUBJECT_NAME, token.getSubject().getRFC2253());
        this.addCertificate(x509DataDom, token);
    }

    private void addCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, this.getXmldsigNamespace(), XMLDSigElement.X509_CERTIFICATE, Utils.toBase64(token.getEncoded()));
    }

    protected void incorporateObject() {
        if (Utils.isArrayNotEmpty(this.params.getSignedAdESObject())) {
            LOG.debug("Incorporating signed XAdES Object from parameter");
            Node signedObjectDom = DomUtils.buildDOM(this.params.getSignedAdESObject()).getDocumentElement();
            signedObjectDom = this.documentDom.importNode(signedObjectDom, true);
            this.signatureDom.appendChild(signedObjectDom);
            return;
        }
        Element objectDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.OBJECT);
        this.signatureDom.appendChild(objectDom);
        this.qualifyingPropertiesDom = DomUtils.addElement(this.documentDom, objectDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementQualifyingProperties());
        DomUtils.addNamespaceAttribute(this.qualifyingPropertiesDom, this.getXadesNamespace());
        this.qualifyingPropertiesDom.setAttribute("Target", "#" + this.deterministicId);
        this.incorporateSignedProperties();
    }

    protected void incorporateReferenceSignedProperties() {
        Element reference = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(reference);
        reference.setAttribute(XMLDSigAttribute.TYPE.getAttributeName(), this.xadesPaths.getSignedPropertiesUri());
        reference.setAttribute(XMLDSigAttribute.URI.getAttributeName(), "#xades-" + this.deterministicId);
        Element transforms = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORMS);
        reference.appendChild(transforms);
        Element transform = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORM);
        transforms.appendChild(transform);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.signedPropertiesCanonicalizationMethod, this.getNodeToCanonicalize(this.signedPropertiesDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Canonicalised REF_2      --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValueOfReference(reference, digestAlgorithm, canonicalizedBytes);
    }

    protected void incorporateReferenceKeyInfo() {
        if (!this.params.isSignKeyInfo()) {
            return;
        }
        Element reference = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(reference);
        reference.setAttribute(XMLDSigAttribute.URI.getAttributeName(), "#keyInfo-" + this.deterministicId);
        Element transforms = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORMS);
        reference.appendChild(transforms);
        Element transform = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORM);
        transforms.appendChild(transform);
        transform.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.keyInfoCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.keyInfoCanonicalizationMethod, this.getNodeToCanonicalize(this.keyInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method   --> {}", (Object)this.keyInfoCanonicalizationMethod);
            LOG.trace("Canonicalised REF_KeyInfo --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValueOfReference(reference, digestAlgorithm, canonicalizedBytes);
    }

    protected DigestAlgorithm getReferenceDigestAlgorithmOrDefault(XAdESSignatureParameters params) {
        return params.getReferenceDigestAlgorithm() != null ? params.getReferenceDigestAlgorithm() : params.getDigestAlgorithm();
    }

    private void incorporateReference(DSSReference dssReference) {
        List<DSSTransform> dssTransforms;
        String referenceType;
        String uri;
        Element referenceDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.REFERENCE);
        this.signedInfoDom.appendChild(referenceDom);
        if (dssReference.getId() != null) {
            referenceDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), dssReference.getId());
        }
        if ((uri = dssReference.getUri()) != null) {
            referenceDom.setAttribute(XMLDSigAttribute.URI.getAttributeName(), uri);
        }
        if ((referenceType = dssReference.getType()) != null) {
            referenceDom.setAttribute(XMLDSigAttribute.TYPE.getAttributeName(), referenceType);
        }
        if (Utils.isCollectionNotEmpty(dssTransforms = dssReference.getTransforms())) {
            Element transformsDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.TRANSFORMS);
            referenceDom.appendChild(transformsDom);
            for (DSSTransform dssTransform : dssTransforms) {
                dssTransform.createTransform(this.documentDom, transformsDom);
            }
        }
        DigestAlgorithm digestAlgorithm = dssReference.getDigestMethodAlgorithm();
        this.incorporateDigestMethod(referenceDom, digestAlgorithm);
        DSSDocument canonicalizedDocument = this.transformReference(dssReference);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference canonicalization method  --> {}", (Object)this.signedInfoCanonicalizationMethod);
        }
        this.incorporateDigestValue(referenceDom, dssReference, digestAlgorithm, canonicalizedDocument);
    }

    private void incorporateDigestValueOfReference(Element referenceDom, DigestAlgorithm digestAlgorithm, byte[] canonicalizedBytes) {
        Element digestValueDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.DIGEST_VALUE);
        String base64EncodedDigestBytes = Utils.toBase64(DSSUtils.digest(digestAlgorithm, canonicalizedBytes));
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        referenceDom.appendChild(digestValueDom);
    }

    private List<DSSReference> createDefaultReferences() {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        references.add(this.createReference(this.detachedDocument, 1));
        return references;
    }

    List<DSSReference> createReferencesForDocuments(List<DSSDocument> documents) {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        int referenceIndex = 1;
        for (DSSDocument dssDocument : documents) {
            references.add(this.createReference(dssDocument, referenceIndex));
            ++referenceIndex;
        }
        return references;
    }

    protected abstract DSSReference createReference(DSSDocument var1, int var2);

    protected abstract DSSDocument transformReference(DSSReference var1);

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.SIGNATURE_VALUE);
        this.signatureDom.appendChild(this.signatureValueDom);
        this.signatureValueDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), VALUE_SUFFIX + this.deterministicId);
    }

    protected void incorporateSignedProperties() {
        this.signedPropertiesDom = DomUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedProperties());
        this.signedPropertiesDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), XADES_SUFFIX + this.deterministicId);
        this.incorporateSignedSignatureProperties();
        this.incorporateSignedDataObjectProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedSignatureProperties());
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignaturePolicyIdentifier());
            String signaturePolicyId = signaturePolicy.getId();
            if (Utils.isStringEmpty(signaturePolicyId)) {
                DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignaturePolicyImplied());
            } else {
                String spuri;
                Object[] documentationReferences;
                String description;
                Element signaturePolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignaturePolicyId());
                Element sigPolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyId());
                Element identifierDom = DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIdentifier(), signaturePolicyId);
                ObjectIdentifierQualifier qualifier = signaturePolicy.getQualifier();
                if (qualifier != null) {
                    identifierDom.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), qualifier.getValue());
                }
                if (Utils.isStringNotEmpty(description = signaturePolicy.getDescription())) {
                    DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDescription(), description);
                }
                if (Utils.isArrayNotEmpty(documentationReferences = signaturePolicy.getDocumentationReferences())) {
                    this.incorporateDocumentationReferences(sigPolicyIdDom, (String[])documentationReferences);
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyHash());
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String bas64EncodedHashValue = Utils.toBase64(hashValue);
                    DomUtils.addTextElement(this.documentDom, sigPolicyHashDom, this.getXmldsigNamespace(), XMLDSigElement.DIGEST_VALUE, bas64EncodedHashValue);
                }
                if (Utils.isStringNotEmpty(spuri = signaturePolicy.getSpuri())) {
                    Element sigPolicyQualifiers = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyQualifiers());
                    Element sigPolicyQualifier = DomUtils.addElement(this.documentDom, sigPolicyQualifiers, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigPolicyQualifier());
                    DomUtils.addTextElement(this.documentDom, sigPolicyQualifier, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSPURI(), spuri);
                }
            }
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = DomUtils.createElementNS(this.documentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigningTime());
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            return;
        }
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        if (this.params.isEn319132()) {
            this.incorporateSigningCertificateV2(certificates);
        } else {
            this.incorporateSigningCertificateV1(certificates);
        }
    }

    private void incorporateSigningCertificateV1(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigningCertificate());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV1(certDom, certificate);
        }
    }

    private void incorporateSigningCertificateV2(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSigningCertificateV2());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV2(certDom, certificate);
        }
    }

    private void incorporateSignedDataObjectProperties() {
        this.signedDataObjectPropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedDataObjectProperties());
        this.incorporateDataObjectFormat();
        this.incorporateCommitmentTypeIndications();
        this.incorporateContentTimestamps();
    }

    private void incorporateDataObjectFormat() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String dataObjectFormatObjectReference = "#" + reference.getId();
            Element dataObjectFormatDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDataObjectFormat());
            dataObjectFormatDom.setAttribute(XAdES132Attribute.OBJECT_REFERENCE.getAttributeName(), dataObjectFormatObjectReference);
            Element mimeTypeDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementMimeType());
            MimeType dataObjectFormatMimeType = this.getReferenceMimeType(reference);
            DomUtils.setTextNode(this.documentDom, mimeTypeDom, dataObjectFormatMimeType.getMimeTypeString());
        }
    }

    private MimeType getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = MimeType.BINARY;
        DSSDocument content = reference.getContents();
        if (content != null && content.getMimeType() != null) {
            dataObjectFormatMimeType = content.getMimeType();
        }
        return dataObjectFormatMimeType;
    }

    private void incorporateContentTimestamps() {
        List<TimestampToken> contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        for (TimestampToken contentTimestamp : contentTimestamps) {
            String timestampId = TIMESTAMP_SUFFIX + contentTimestamp.getDSSIdAsString();
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element allDataObjectsTimestampDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementAllDataObjectsTimeStamp());
                allDataObjectsTimestampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), timestampId);
                this.addTimestamp(allDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element individualDataObjectsTimestampDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIndividualDataObjectsTimeStamp());
                individualDataObjectsTimestampDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), timestampId);
                this.addTimestamp(individualDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            throw new DSSException("Only types ALL_DATA_OBJECTS_TIMESTAMP and INDIVIDUAL_DATA_OBJECTS_TIMESTAMP are allowed");
        }
    }

    private void incorporateSignerRole() {
        List<String> claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        List<String> signedAssertions = this.params.bLevel().getSignedAssertions();
        Element signerRoleDom = null;
        if (claimedSignerRoles != null) {
            signerRoleDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignerRoleV2()) : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignerRole());
            if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
                Element claimedRolesDom = DomUtils.addElement(this.documentDom, signerRoleDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementClaimedRoles());
                this.addRoles(claimedSignerRoles, claimedRolesDom, this.getCurrentXAdESElements().getElementClaimedRole());
            }
        }
        if (signedAssertions != null && this.params.isEn319132()) {
            if (signerRoleDom == null) {
                signerRoleDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignerRoleV2());
            }
            if (Utils.isCollectionNotEmpty(signedAssertions)) {
                Element signedAssertionsDom = DomUtils.addElement(this.documentDom, signerRoleDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedAssertions());
                this.addAssertions(signedAssertions, signedAssertionsDom);
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, DSSElement roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DomUtils.addElement(this.documentDom, rolesDom, this.getXadesNamespace(), roleType);
            DomUtils.setTextNode(this.documentDom, roleDom, signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null && !signatureProductionPlace.isEmpty()) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignatureProductionPlaceV2()) : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignatureProductionPlace());
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCity(), city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreet()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementStreetAddress(), streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementStateOrProvince(), stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementPostalCode(), postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCountryName(), country);
            }
        }
    }

    private void incorporateCommitmentTypeIndications() {
        List<CommitmentType> commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            for (CommitmentType commitmentTypeIndication : commitmentTypeIndications) {
                Object[] documentationReferences;
                String description;
                Element commitmentTypeIndicationDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCommitmentTypeIndication());
                Element commitmentTypeIdDom = DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementCommitmentTypeId());
                if (commitmentTypeIndication.getUri() == null) {
                    throw new DSSException("The commitmentTypeIndication URI must be defined for XAdES creation!");
                }
                Element identifierDom = DomUtils.addTextElement(this.documentDom, commitmentTypeIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementIdentifier(), commitmentTypeIndication.getUri());
                ObjectIdentifierQualifier qualifier = commitmentTypeIndication.getQualifier();
                if (qualifier != null) {
                    identifierDom.setAttribute(XAdES132Attribute.QUALIFIER.getAttributeName(), qualifier.getValue());
                }
                if ((description = commitmentTypeIndication.getDescription()) != null) {
                    DomUtils.addTextElement(this.documentDom, commitmentTypeIdDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDescription(), description);
                }
                if (Utils.isArrayNotEmpty(documentationReferences = commitmentTypeIndication.getDocumentationReferences())) {
                    this.incorporateDocumentationReferences(commitmentTypeIdDom, (String[])documentationReferences);
                }
                DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementAllSignedDataObjects());
            }
        }
    }

    private void incorporateDocumentationReferences(Element parentElement, String[] documentationReferences) {
        Element documentReferencesDom = DomUtils.addElement(this.documentDom, parentElement, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDocumentationReferences());
        for (String ref : documentationReferences) {
            DomUtils.addTextElement(this.documentDom, documentReferencesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementDocumentationReference(), ref);
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64(signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        return this.createXmlDocument();
    }

    protected void addTimestamp(Element timestampElement, TimestampToken token) {
        String canonicalizationMethod;
        List<TimestampInclude> includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = DomUtils.createElementNS(this.documentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementInclude());
                String uri = include.getURI();
                if (!uri.startsWith("#")) {
                    uri = "#" + uri;
                }
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        if (!Utils.isStringNotEmpty(canonicalizationMethod = token.getCanonicalizationMethod())) {
            throw new DSSException("Unable to create a timestamp with empty canonicalization method. See EN 319 132-1: 4.5 Managing canonicalization of XML nodesets.");
        }
        Element canonicalizationMethodElement = DomUtils.createElementNS(this.documentDom, this.getXmldsigNamespace(), XMLDSigElement.CANONICALIZATION_METHOD);
        canonicalizationMethodElement.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), canonicalizationMethod);
        timestampElement.appendChild(canonicalizationMethodElement);
        Element encapsulatedTimestampElement = DomUtils.createElementNS(this.documentDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementEncapsulatedTimeStamp());
        encapsulatedTimestampElement.setTextContent(Utils.toBase64(token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
    }

    protected byte[] applyTransformations(DSSReference reference, Node nodeToTransform) {
        byte[] transformedReferenceBytes = null;
        List<DSSTransform> transforms = reference.getTransforms();
        if (Utils.isCollectionNotEmpty(transforms)) {
            Iterator<DSSTransform> iterator = transforms.iterator();
            while (iterator.hasNext()) {
                DSSTransform transform = iterator.next();
                transformedReferenceBytes = transform.getBytesAfterTranformation(nodeToTransform, reference.getUri());
                if (!iterator.hasNext()) continue;
                nodeToTransform = DomUtils.buildDOM(transformedReferenceBytes);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reference bytes after transforms: ");
                LOG.debug(new String(transformedReferenceBytes));
            }
            return transformedReferenceBytes;
        }
        return DSSXMLUtils.getNodeBytes(nodeToTransform);
    }

    protected Node getNodeToCanonicalize(Node node) {
        if (this.params.isPrettyPrint()) {
            return DSSXMLUtils.getIndentedNode(this.documentDom, node);
        }
        return node;
    }

    @Override
    protected void alignNodes() {
        if (this.unsignedSignaturePropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.unsignedSignaturePropertiesDom);
        }
        if (this.qualifyingPropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
        }
    }

    private void addAssertions(List<String> signedAssertions, Element rolesDom) {
        for (String signedAssertion : signedAssertions) {
            Element roleDom = DomUtils.addElement(this.documentDom, rolesDom, this.getXadesNamespace(), this.getCurrentXAdESElements().getElementSignedAssertion());
            Document samlAssertion = DomUtils.buildDOM(signedAssertion);
            Element docEl = samlAssertion.getDocumentElement();
            Node node = this.documentDom.importNode(docEl, true);
            roleDom.appendChild(node);
        }
    }
}

