/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESTimestampParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.TimestampContainerForm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.PAdESTimestampParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDocumentSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteDocumentSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDocumentSignatureServiceImpl.class);
    private DocumentSignatureService<XAdESSignatureParameters, XAdESTimestampParameters> xadesService;
    private DocumentSignatureService<CAdESSignatureParameters, CAdESTimestampParameters> cadesService;
    private DocumentSignatureService<PAdESSignatureParameters, PAdESTimestampParameters> padesService;
    private DocumentSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> asicWithXAdESService;
    private DocumentSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters> asicWithCAdESService;

    public void setXadesService(DocumentSignatureService<XAdESSignatureParameters, XAdESTimestampParameters> xadesService) {
        this.xadesService = xadesService;
    }

    public void setCadesService(DocumentSignatureService<CAdESSignatureParameters, CAdESTimestampParameters> cadesService) {
        this.cadesService = cadesService;
    }

    public void setPadesService(DocumentSignatureService<PAdESSignatureParameters, PAdESTimestampParameters> padesService) {
        this.padesService = padesService;
    }

    public void setAsicWithXAdESService(DocumentSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters> asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    public void setAsicWithCAdESService(DocumentSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters> asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    private DocumentSignatureService getServiceForSignature(SignatureForm signatureForm, ASiCContainerType asicContainerType) {
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + (Object)((Object)signatureForm));
        }
        switch (signatureForm) {
            case XAdES: {
                return this.xadesService;
            }
            case CAdES: {
                return this.cadesService;
            }
            case PAdES: {
                return this.padesService;
            }
        }
        throw new DSSException("Unrecognized format " + (Object)((Object)signatureForm));
    }

    private DocumentSignatureService getServiceForTimestamp(TimestampContainerForm timestampContainerForm) {
        if (timestampContainerForm != null) {
            switch (timestampContainerForm) {
                case PDF: {
                    return this.padesService;
                }
                case ASiC_E: 
                case ASiC_S: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (only PDF, ASiC-E and ASiC-S are allowed) : " + (Object)((Object)timestampContainerForm));
        }
        throw new DSSException("The timestampContainerForm must be defined!");
    }

    @Override
    public ToBeSignedDTO getDataToSign(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("GetDataToSign in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        ToBeSigned dataToSign = service.getDataToSign(dssDocument, parameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO(dataToSign);
    }

    @Override
    public RemoteDocument signDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("SignDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        DSSDocument signDocument = service.signDocument(dssDocument, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(signDocument);
    }

    @Override
    public RemoteDocument extendDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getSignatureLevel(), "signatureLevel must be defined!");
        LOG.info("ExtendDocument in process...");
        SerializableSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters.getSignatureLevel().getSignatureForm(), remoteParameters.getAsicContainerType());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        DSSDocument extendDocument = service.extendDocument(dssDocument, parameters);
        LOG.info("ExtendDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(extendDocument);
    }

    @Override
    public RemoteDocument timestamp(RemoteDocument remoteDocument, RemoteTimestampParameters remoteParameters) {
        Objects.requireNonNull(remoteDocument, "remoteDocument must be defined!");
        Objects.requireNonNull(remoteParameters, "remoteParameters must be defined!");
        Objects.requireNonNull(remoteParameters.getTimestampContainerForm(), "signatureForm must be defined!");
        LOG.info("Timestamp document in process...");
        TimestampParameters parameters = this.toTimestampParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForTimestamp(remoteParameters.getTimestampContainerForm());
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        DSSDocument timestampedDocument = service.timestamp(dssDocument, parameters);
        LOG.info("Timestamp document is finished");
        return RemoteDocumentConverter.toRemoteDocument(timestampedDocument);
    }
}

