/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.Type;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;

public class CertificateQualificationCalculation {
    private final CertificateWrapper endEntityCert;
    private final TrustedServiceWrapper caqcTrustService;

    public CertificateQualificationCalculation(CertificateWrapper endEntityCert, TrustedServiceWrapper caqcTrustService) {
        this.endEntityCert = endEntityCert;
        this.caqcTrustService = caqcTrustService;
    }

    public CertificateQualification getQualification() {
        QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.endEntityCert, this.caqcTrustService);
        QualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
        TypeStrategy typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.endEntityCert, this.caqcTrustService, qualifiedStatus);
        Type type = typeStrategy.getType();
        QSCDStrategy qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.endEntityCert, this.caqcTrustService, qualifiedStatus);
        QSCDStatus qscdStatus = qscdStrategy.getQSCDStatus();
        return CertQualificationMatrix.getCertQualification(qualifiedStatus, type, qscdStatus);
    }
}

