/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignatureTokenConnection
implements SignatureTokenConnection {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSignatureTokenConnection.class);

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        return this.sign(toBeSigned, digestAlgorithm, null, keyEntry);
    }

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, mgf);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        byte[] bytes = toBeSigned.getBytes();
        AlgorithmParameterSpec param = null;
        if (mgf != null) {
            param = this.createPSSParam(digestAlgorithm);
        }
        try {
            byte[] signatureValue = this.sign(bytes, javaSignatureAlgorithm, param, keyEntry);
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(signatureAlgorithm);
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    @Override
    public SignatureValue signDigest(Digest digest, DSSPrivateKeyEntry keyEntry) throws DSSException {
        return this.signDigest(digest, null, keyEntry);
    }

    @Override
    public SignatureValue signDigest(Digest digest, MaskGenerationFunction mgf, DSSPrivateKeyEntry keyEntry) throws DSSException {
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        SignatureAlgorithm signatureAlgorithmNONE = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, null, mgf);
        String javaSignatureAlgorithm = signatureAlgorithmNONE.getJCEId();
        byte[] digestedBytes = digest.getValue();
        AlgorithmParameterSpec param = null;
        if (mgf != null) {
            param = this.createPSSParam(digest.getAlgorithm());
        }
        try {
            byte[] signatureValue = this.sign(digestedBytes, javaSignatureAlgorithm, param, keyEntry);
            SignatureValue value = new SignatureValue();
            value.setAlgorithm(SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digest.getAlgorithm(), mgf));
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e) {
            throw new DSSException(e);
        }
    }

    private byte[] sign(byte[] bytes, String javaSignatureAlgorithm, AlgorithmParameterSpec param, DSSPrivateKeyEntry keyEntry) throws GeneralSecurityException {
        if (!(keyEntry instanceof KSPrivateKeyEntry)) {
            throw new IllegalArgumentException("Only KSPrivateKeyEntry are supported");
        }
        LOG.info("Signature algorithm : {}", (Object)javaSignatureAlgorithm);
        Signature signature = this.getSignatureInstance(javaSignatureAlgorithm);
        if (param != null) {
            signature.setParameter(param);
        }
        signature.initSign(((KSPrivateKeyEntry)keyEntry).getPrivateKey());
        signature.update(bytes);
        return signature.sign();
    }

    protected Signature getSignatureInstance(String javaSignatureAlgorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(javaSignatureAlgorithm);
    }

    protected AlgorithmParameterSpec createPSSParam(DigestAlgorithm digestAlgo) {
        String digestJavaName = digestAlgo.getJavaName();
        return new PSSParameterSpec(digestJavaName, "MGF1", new MGF1ParameterSpec(digestJavaName), digestAlgo.getSaltLength(), 1);
    }
}

