/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RepositoryRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationException;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcRevocationSource<R extends Revocation>
extends RepositoryRevocationSource<R> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRevocationSource.class);
    private static final long serialVersionUID = 8752226611048306095L;
    protected transient DataSource dataSource;

    protected abstract String getCreateTableQuery();

    protected abstract String getTableExistenceQuery();

    protected abstract String getFindRevocationQuery();

    protected abstract String getDeleteTableQuery();

    protected abstract String getRemoveRevocationTokenEntryQuery();

    protected abstract RevocationToken<R> buildRevocationTokenFromResult(ResultSet var1, CertificateToken var2, CertificateToken var3) throws RevocationException;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RevocationToken<R> findRevocation(String key, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        ResultSet rs;
        PreparedStatement s2;
        Connection c;
        block5: {
            c = null;
            s2 = null;
            rs = null;
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(this.getFindRevocationQuery());
            s2.setString(1, key);
            rs = s2.executeQuery();
            if (!rs.next()) break block5;
            RevocationToken<R> revocationToken = this.buildRevocationTokenFromResult(rs, certificateToken, issuerCertificateToken);
            this.closeQuietly(c, s2, rs);
            return revocationToken;
        }
        try {
            c.commit();
            this.closeQuietly(c, s2, rs);
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to select CRL from the DB", e);
                this.rollback(c);
                this.closeQuietly(c, s2, rs);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, rs);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRevocation(RevocationToken<R> token) {
        Connection c = null;
        PreparedStatement s2 = null;
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(this.getRemoveRevocationTokenEntryQuery());
            s2.setString(1, token.getRevocationTokenKey());
            s2.executeUpdate();
            c.commit();
            LOG.debug("Revocation token with key '{}' successfully removed from DB", (Object)token.getRevocationTokenKey());
            this.closeQuietly(c, s2, null);
        }
        catch (SQLException e) {
            try {
                LOG.error("Unable to remove Revocation token from the DB", e);
                this.rollback(c);
                this.closeQuietly(c, s2, null);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
        }
    }

    public void initTable() throws SQLException {
        if (!this.isTableExists()) {
            LOG.debug("Table does not exist. Creating a new table...");
            this.createTable();
            LOG.info("Table was created.");
        } else {
            LOG.debug("Table already exists.");
        }
    }

    private void createTable() throws SQLException {
        Connection c = null;
        Statement s2 = null;
        try {
            c = this.dataSource.getConnection();
            s2 = c.createStatement();
            s2.executeUpdate(this.getCreateTableQuery());
            c.commit();
        }
        catch (SQLException e) {
            this.rollback(c);
            throw e;
        }
        finally {
            this.closeQuietly(c, s2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExists() {
        boolean tableExists;
        Connection c = null;
        Statement s2 = null;
        try {
            c = this.dataSource.getConnection();
            s2 = c.createStatement();
            tableExists = s2.execute(this.getTableExistenceQuery());
        }
        catch (SQLException e) {
            tableExists = false;
        }
        finally {
            this.closeQuietly(c, s2, null);
        }
        return tableExists;
    }

    public void destroyTable() throws SQLException {
        if (this.isTableExists()) {
            LOG.debug("Table exists. Removing the table...");
            this.dropTable();
            LOG.info("Table was destroyed.");
        } else {
            LOG.warn("Cannot drop the table. Table does not exist.");
        }
    }

    private void dropTable() throws SQLException {
        Connection c = null;
        Statement s2 = null;
        try {
            c = this.dataSource.getConnection();
            s2 = c.createStatement();
            s2.execute(this.getDeleteTableQuery());
            c.commit();
        }
        catch (SQLException e) {
            this.rollback(c);
            throw e;
        }
        finally {
            this.closeQuietly(c, s2, null);
        }
    }

    protected void rollback(Connection c) {
        if (c != null) {
            try {
                LOG.warn("Transaction is being rolled back");
                c.rollback();
            }
            catch (SQLException e) {
                LOG.error("Unable to rollback", e);
            }
        }
    }

    protected void closeQuietly(Connection c, Statement s2, ResultSet rs) {
        this.closeQuietly(rs);
        this.closeQuietly(s2);
        this.closeQuietly(c);
    }

    private void closeQuietly(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(Statement s2) {
        try {
            if (s2 != null) {
                s2.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

