/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.nativedrawer;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pdf.visible.AbstractFontMetrics;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PdfBoxFontMetrics
extends AbstractFontMetrics {
    private final PDFont pdFont;

    public PdfBoxFontMetrics(PDFont pdFont) {
        this.pdFont = pdFont;
    }

    @Override
    public float getWidth(String str, float size) {
        try {
            return this.pdFont.getStringWidth(str) / 1000.0f * size;
        }
        catch (IOException e) {
            throw new DSSException("Unable to compute string width!");
        }
    }

    @Override
    public float getHeight(String str, float size) {
        try {
            return this.pdFont.getBoundingBox().getHeight() / 1000.0f * size;
        }
        catch (IOException e) {
            throw new DSSException("Unable to compute string height!");
        }
    }
}

