/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderPdfObjFactory
implements IPdfObjFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLoaderPdfObjFactory.class);

    @Override
    public PDFSignatureService newPAdESSignatureService() {
        return this.getIPdfObjFactory().newPAdESSignatureService();
    }

    @Override
    public PDFSignatureService newContentTimestampService() {
        return this.getIPdfObjFactory().newContentTimestampService();
    }

    @Override
    public PDFSignatureService newSignatureTimestampService() {
        return this.getIPdfObjFactory().newSignatureTimestampService();
    }

    @Override
    public PDFSignatureService newArchiveTimestampService() {
        return this.getIPdfObjFactory().newArchiveTimestampService();
    }

    private IPdfObjFactory getIPdfObjFactory() {
        ServiceLoader<IPdfObjFactory> loader = ServiceLoader.load(IPdfObjFactory.class);
        Iterator<IPdfObjFactory> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ExceptionInInitializerError("No implementation found for IPdfObjFactory in classpath, please choose between modules 'dss-pades-pdfbox' or 'dss-pades-openpdf'");
        }
        IPdfObjFactory instance = iterator.next();
        LOG.debug("Current instance of IPdfObjFactory : {}", (Object)instance.getClass().getSimpleName());
        return instance;
    }
}

