/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.pades.signature.PAdESLevelBaselineT;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PDFDocumentValidator;
import eu.europa.esig.dss.pdf.DSSDictionaryCallback;
import eu.europa.esig.dss.pdf.IPdfObjFactory;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import eu.europa.esig.dss.validation.ValidationDataForInclusionBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class PAdESLevelBaselineLT
extends PAdESLevelBaselineT {
    private final CertificateVerifier certificateVerifier;

    PAdESLevelBaselineLT(TSPSource tspSource, CertificateVerifier certificateVerifier, IPdfObjFactory pdfObjectFactory) {
        super(tspSource, pdfObjectFactory);
        this.certificateVerifier = certificateVerifier;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, PAdESSignatureParameters parameters) throws DSSException {
        PDFDocumentValidator pdfDocumentValidator = this.getPDFDocumentValidator(document, parameters);
        List<AdvancedSignature> signatures = pdfDocumentValidator.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new DSSException("No signature to be extended");
        }
        for (AdvancedSignature advancedSignature : signatures) {
            if (!this.isRequireDocumentTimestamp(advancedSignature)) continue;
            document = super.extendSignatures(document, parameters);
            pdfDocumentValidator = this.getPDFDocumentValidator(document, parameters);
            break;
        }
        signatures = pdfDocumentValidator.getSignatures();
        LinkedList<DSSDictionaryCallback> callbacks = new LinkedList<DSSDictionaryCallback>();
        for (AdvancedSignature signature : signatures) {
            if (!(signature instanceof PAdESSignature)) continue;
            PAdESSignature padesSignature = (PAdESSignature)signature;
            this.assertExtendSignaturePossible(padesSignature);
            callbacks.add(this.validate(padesSignature));
        }
        PDFSignatureService pDFSignatureService = this.newPdfSignatureService();
        return pDFSignatureService.addDssDictionary(document, callbacks, parameters.getPasswordProtection());
    }

    private PDFDocumentValidator getPDFDocumentValidator(DSSDocument document, PAdESSignatureParameters parameters) {
        PDFDocumentValidator pdfDocumentValidator = new PDFDocumentValidator(document);
        pdfDocumentValidator.setCertificateVerifier(this.certificateVerifier);
        pdfDocumentValidator.setPasswordProtection(parameters.getPasswordProtection());
        return pdfDocumentValidator;
    }

    private boolean isRequireDocumentTimestamp(AdvancedSignature signature) {
        List<TimestampToken> signatureTimestamps = signature.getSignatureTimestamps();
        List<TimestampToken> archiveTimestamps = signature.getArchiveTimestamps();
        return Utils.isCollectionEmpty(signatureTimestamps) && Utils.isCollectionEmpty(archiveTimestamps);
    }

    private void assertExtendSignaturePossible(PAdESSignature padesSignature) throws DSSException {
        if (padesSignature.areAllSelfSignedCertificates()) {
            throw new DSSException("Cannot extend the signature. The signature contains only self-signed certificate chains!");
        }
    }

    protected DSSDictionaryCallback validate(PAdESSignature signature) {
        ValidationContext validationContext = signature.getSignatureValidationContext(this.certificateVerifier);
        ValidationDataForInclusionBuilder validationDataForInclusionBuilder = new ValidationDataForInclusionBuilder(validationContext, signature.getCompleteCertificateSource());
        ValidationDataForInclusion validationDataForInclusion = validationDataForInclusionBuilder.build();
        DSSDictionaryCallback validationCallback = new DSSDictionaryCallback();
        validationCallback.setSignature(signature);
        Set<CertificateToken> certificatesForInclusion = validationDataForInclusion.getCertificateTokens();
        validationCallback.setCertificates(certificatesForInclusion);
        validationCallback.setCrls(validationDataForInclusion.getCrlTokens());
        validationCallback.setOcsps(validationDataForInclusion.getOcspTokens());
        return validationCallback;
    }
}

