/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.jaxb.ObjectFactory;
import eu.europa.esig.dss.jaxb.XmlDefinerUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class DetailedReportXmlDefiner {
    private static final String DETAILED_REPORT_SCHEMA_LOCATION = "/xsd/DetailedReport.xsd";
    private static final String DETAILED_REPORT_XSLT_HTML_BOOTSTRAP3_LOCATION = "/xslt/html/detailed-report.xslt";
    private static final String DETAILED_REPORT_XSLT_HTML_BOOTSTRAP4_LOCATION = "/xslt/html/detailed-report-bootstrap4.xslt";
    private static final String DETAILED_REPORT_XSLT_PDF_LOCATION = "/xslt/pdf/detailed-report.xslt";
    public static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static JAXBContext jc;
    private static Schema schema;
    private static Templates htmlBootstrap3Templates;
    private static Templates htmlBootstrap4Templates;
    private static Templates pdfTemplates;

    private DetailedReportXmlDefiner() {
    }

    public static JAXBContext getJAXBContext() throws JAXBException {
        if (jc == null) {
            jc = JAXBContext.newInstance(ObjectFactory.class);
        }
        return jc;
    }

    public static Schema getSchema() throws IOException, SAXException {
        if (schema == null) {
            try (InputStream isXSDDetailedReport = DetailedReportXmlDefiner.class.getResourceAsStream(DETAILED_REPORT_SCHEMA_LOCATION);){
                SchemaFactory sf = XmlDefinerUtils.getInstance().getSecureSchemaFactory();
                schema = sf.newSchema(new Source[]{new StreamSource(isXSDDetailedReport)});
            }
        }
        return schema;
    }

    public static Templates getHtmlBootstrap3Templates() throws TransformerConfigurationException, IOException {
        if (htmlBootstrap3Templates == null) {
            htmlBootstrap3Templates = DetailedReportXmlDefiner.loadTemplates(DETAILED_REPORT_XSLT_HTML_BOOTSTRAP3_LOCATION);
        }
        return htmlBootstrap3Templates;
    }

    public static Templates getHtmlBootstrap4Templates() throws TransformerConfigurationException, IOException {
        if (htmlBootstrap4Templates == null) {
            htmlBootstrap4Templates = DetailedReportXmlDefiner.loadTemplates(DETAILED_REPORT_XSLT_HTML_BOOTSTRAP4_LOCATION);
        }
        return htmlBootstrap4Templates;
    }

    public static Templates getPdfTemplates() throws TransformerConfigurationException, IOException {
        if (pdfTemplates == null) {
            pdfTemplates = DetailedReportXmlDefiner.loadTemplates(DETAILED_REPORT_XSLT_PDF_LOCATION);
        }
        return pdfTemplates;
    }

    private static Templates loadTemplates(String path) throws TransformerConfigurationException, IOException {
        try (InputStream is = DetailedReportXmlDefiner.class.getResourceAsStream(path);){
            TransformerFactory transformerFactory = XmlDefinerUtils.getInstance().getSecureTransformerFactory();
            Templates templates = transformerFactory.newTemplates(new StreamSource(is));
            return templates;
        }
    }
}

