/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignedAttributes;
import eu.europa.esig.dss.cades.validation.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampLocation;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.validation.CMSCRLSource;
import eu.europa.esig.dss.validation.CMSCertificateSource;
import eu.europa.esig.dss.validation.CMSOCSPSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.timestamp.AbstractTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampSource
extends AbstractTimestampSource<CAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampSource.class);
    protected final transient SignerInformation signerInformation;
    protected final transient CMSSignedData cmsSignedData;
    protected final transient List<DSSDocument> detachedDocuments;

    public CAdESTimestampSource(CAdESSignature signature) {
        super(signature);
        this.cmsSignedData = signature.getCmsSignedData();
        this.detachedDocuments = signature.getDetachedContents();
        this.signerInformation = signature.getSignerInformation();
    }

    @Override
    protected CAdESTimestampDataBuilder getTimestampDataBuilder() {
        CadesLevelBaselineLTATimestampExtractor timestampExtractor = new CadesLevelBaselineLTATimestampExtractor(this.cmsSignedData, this.certificateSource.getAllCertificateTokens());
        return new CAdESTimestampDataBuilder(this.cmsSignedData, this.signerInformation, this.detachedDocuments, timestampExtractor);
    }

    @Override
    protected SignatureProperties<CAdESAttribute> getSignedSignatureProperties() {
        return CAdESSignedAttributes.build(this.signerInformation);
    }

    @Override
    protected SignatureProperties<CAdESAttribute> getUnsignedSignatureProperties() {
        return CAdESUnsignedAttributes.build(this.signerInformation);
    }

    @Override
    protected boolean isContentTimestamp(CAdESAttribute signedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals(signedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAllDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isIndividualDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    @Override
    protected boolean isSignatureTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certificateRefs.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeCertificateRefsOid.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationRefs.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeRevocationRefsOid.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certValues.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationValues.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isAttrAuthoritiesCertValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isAttributeRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestampV2(unsignedAttribute) || this.isArchiveTimestampV3(unsignedAttribute);
    }

    private boolean isArchiveTimestampV2(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV2.equals(unsignedAttribute.getASN1Oid());
    }

    private boolean isArchiveTimestampV3(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV3.equals(unsignedAttribute.getASN1Oid());
    }

    @Override
    protected boolean isTimeStampValidationData(CAdESAttribute unsignedAttribute) {
        return false;
    }

    @Override
    protected TimestampToken makeTimestampToken(CAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        TimeStampToken timestamp = signatureAttribute.toTimeStampToken();
        if (timestamp == null) {
            return null;
        }
        return new TimestampToken(timestamp, timestampType, references, TimestampLocation.CAdES);
    }

    @Override
    protected List<TimestampedReference> getIndividualContentTimestampedReferences(CAdESAttribute signedAttribute) {
        throw new DSSException("Not applicable for CAdES!");
    }

    @Override
    protected List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken timestampToken) {
        return this.getSignedDataReferences(timestampToken);
    }

    protected List<TimestampedReference> getSignedDataReferences(TimestampToken timestampToken) {
        if (ArchiveTimestampType.CAdES_V2.equals((Object)timestampToken.getArchiveTimestampType()) || ArchiveTimestampType.CAdES.equals((Object)timestampToken.getArchiveTimestampType())) {
            return this.getSignatureSignedDataReferences();
        }
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        ASN1Sequence atsHashIndex = DSSASN1Utils.getAtsHashIndex(timestampToken.getUnsignedAttributes());
        if (atsHashIndex != null) {
            DigestAlgorithm digestAlgorithm = this.getHashIndexDigestAlgorithm(atsHashIndex);
            List<TimestampedReference> certificateReferences = this.getSignedDataCertificateReferences(atsHashIndex, digestAlgorithm, timestampToken.getDSSIdAsString());
            references.addAll(certificateReferences);
            List<TimestampedReference> revocationReferences = this.getSignedDataRevocationReferences(atsHashIndex, digestAlgorithm, timestampToken.getDSSIdAsString());
            references.addAll(revocationReferences);
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataCertificateReferences(ASN1Sequence atsHashIndex, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureCertificateSource instanceof CMSCertificateSource) {
            ASN1Sequence certsHashIndex = DSSASN1Utils.getCertificatesHashIndex(atsHashIndex);
            List<DEROctetString> certsHashList = DSSASN1Utils.getDEROctetStrings(certsHashIndex);
            for (CertificateToken certificate : this.signatureCertificateSource.getSignedDataCertificates()) {
                if (this.isDigestValuePresent(certificate.getDigest(digestAlgorithm), certsHashList)) {
                    this.addReference(references, certificate.getDSSId(), TimestampedObjectType.CERTIFICATE);
                    continue;
                }
                LOG.warn("The certificate with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)certificate.getDSSIdAsString(), (Object)timestampId);
            }
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataRevocationReferences(ASN1Sequence atsHashIndex, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        ASN1Sequence crlsHashIndex = DSSASN1Utils.getCRLHashIndex(atsHashIndex);
        List<DEROctetString> crlsHashList = DSSASN1Utils.getDEROctetStrings(crlsHashIndex);
        if (this.signatureCRLSource instanceof CMSCRLSource) {
            CMSCRLSource cmsCRLSource = (CMSCRLSource)this.signatureCRLSource;
            for (EncapsulatedRevocationTokenIdentifier token : cmsCRLSource.getCMSSignedDataRevocationBinaries()) {
                if (this.isDigestValuePresent(token.getDigestValue(digestAlgorithm), crlsHashList)) {
                    this.addReference(references, token, TimestampedObjectType.REVOCATION);
                    continue;
                }
                LOG.warn("The CRL Token with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)token.asXmlId(), (Object)timestampId);
            }
        }
        List<TimestampedReference> ocspReferences = this.getSignedDataOCSPReferences(crlsHashList, digestAlgorithm, timestampId);
        references.addAll(ocspReferences);
        return references;
    }

    private List<TimestampedReference> getSignedDataOCSPReferences(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm, String timestampId) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureOCSPSource instanceof CMSOCSPSource) {
            CMSOCSPSource cmsocspSource = (CMSOCSPSource)this.signatureOCSPSource;
            for (EncapsulatedRevocationTokenIdentifier token : cmsocspSource.getCMSSignedDataRevocationBinaries()) {
                OCSPResponseBinary binary = (OCSPResponseBinary)token;
                OtherRevocationInfoFormat otherRevocationInfoFormat = new OtherRevocationInfoFormat(binary.getAsn1ObjectIdentifier(), (ASN1Encodable)DSSASN1Utils.toASN1Primitive(binary.getBasicOCSPRespContent()));
                DERTaggedObject derTaggedObject = new DERTaggedObject(false, 1, otherRevocationInfoFormat);
                if (this.isDigestValuePresent(DSSUtils.digest(digestAlgorithm, DSSASN1Utils.getDEREncoded(derTaggedObject)), crlsHashList)) {
                    this.addReference(references, binary, TimestampedObjectType.REVOCATION);
                    continue;
                }
                LOG.warn("The OCSP Token with id [{}] was not included to the message imprint of timestamp with id [{}] or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)binary.asXmlId(), (Object)timestampId);
            }
        }
        return references;
    }

    @Override
    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (this.signatureCertificateSource instanceof CMSCertificateSource) {
            this.addReferences(references, this.createReferencesForCertificates(this.signatureCertificateSource.getSignedDataCertificates()));
        }
        if (this.signatureCRLSource instanceof CMSCRLSource) {
            for (EncapsulatedRevocationTokenIdentifier token : ((CMSCRLSource)this.signatureCRLSource).getCMSSignedDataRevocationBinaries()) {
                this.addReference(references, token, TimestampedObjectType.REVOCATION);
            }
        }
        if (this.signatureOCSPSource instanceof CMSOCSPSource) {
            for (EncapsulatedRevocationTokenIdentifier token : ((CMSOCSPSource)this.signatureOCSPSource).getCMSSignedDataRevocationBinaries()) {
                this.addReference(references, token, TimestampedObjectType.REVOCATION);
            }
        }
        return references;
    }

    private DigestAlgorithm getHashIndexDigestAlgorithm(ASN1Sequence atsHashIndex) {
        AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier(atsHashIndex);
        return algorithmIdentifier != null ? DigestAlgorithm.forOID(algorithmIdentifier.getAlgorithm().getId()) : CMSUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
    }

    private boolean isDigestValuePresent(byte[] digestValue, List<DEROctetString> hashList) {
        return hashList.contains(new DEROctetString(digestValue));
    }

    @Override
    protected List<CertificateRef> getCertificateRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            OtherCertID otherCertId = OtherCertID.getInstance(seq.getObjectAt(ii));
            certRefs.add(DSSASN1Utils.getCertificateRef(otherCertId));
        }
        return certRefs;
    }

    @Override
    protected List<CRLRef> getCRLRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> refs = new ArrayList<CRLRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            CrlOcspRef otherRefId = CrlOcspRef.getInstance(seq.getObjectAt(ii));
            CrlListID otherCrlIds = otherRefId.getCrlids();
            if (otherCrlIds == null) continue;
            for (CrlValidatedID id : otherCrlIds.getCrls()) {
                refs.add(new CRLRef(id));
            }
        }
        return refs;
    }

    @Override
    protected List<OCSPRef> getOCSPRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> refs = new ArrayList<OCSPRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int i = 0; i < seq.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance(seq.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                refs.add(new OCSPRef(ocspResponsesID));
            }
        }
        return refs;
    }

    @Override
    protected List<Identifier> getEncapsulatedCertificateIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            try {
                Certificate cs = Certificate.getInstance(seq.getObjectAt(ii));
                CertificateToken certificateToken = DSSUtils.loadCertificate(cs.getEncoded());
                certificateIdentifiers.add(certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    @Override
    protected List<Identifier> getEncapsulatedCRLIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> crlBinaryIdentifiers = new ArrayList<Identifier>();
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues(asn1Object);
        if (revocationValues != null) {
            for (CertificateList revValue : revocationValues.getCrlVals()) {
                try {
                    crlBinaryIdentifiers.add(CRLUtils.buildCRLBinary(revValue.getEncoded()));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse CRL binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return crlBinaryIdentifiers;
    }

    @Override
    protected List<Identifier> getEncapsulatedOCSPIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> ocspIdentifiers = new ArrayList<Identifier>();
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues(asn1Object);
        if (revocationValues != null) {
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                try {
                    BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                    ocspIdentifiers.add(OCSPResponseBinary.build(basicOCSPResp));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse OCSP response binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return ocspIdentifiers;
    }

    @Override
    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        if (OID.id_aa_ets_archiveTimestampV2.equals(unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V2;
        }
        if (OID.id_aa_ets_archiveTimestampV3.equals(unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V3;
        }
        return ArchiveTimestampType.CAdES;
    }

    @Override
    protected void addEncapsulatedValuesFromTimestamp(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        super.addEncapsulatedValuesFromTimestamp(references, timestampedTimestamp);
        TimestampCRLSource timeStampCRLSource = timestampedTimestamp.getCRLSource();
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampCRLSource.getAllRevocationBinaries()) {
            this.addReference(references, binary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampCRLSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, binary, TimestampedObjectType.REVOCATION);
        }
        TimestampOCSPSource timeStampOCSPSource = timestampedTimestamp.getOCSPSource();
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampOCSPSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, binary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier binary : timeStampOCSPSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, binary, TimestampedObjectType.REVOCATION);
        }
    }
}

