/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asics;

import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asics.AbstractGetDataToSignASiCSWithXAdES;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DataToSignASiCSWithXAdESFromFiles
extends AbstractGetDataToSignASiCSWithXAdES
implements GetDataToSignASiCWithXAdESHelper {
    private final List<DSSDocument> filesToBeSigned;
    private final Date signingDate;
    private final ASiCParameters asicParameters;
    private List<DSSDocument> signedDocuments;

    public DataToSignASiCSWithXAdESFromFiles(List<DSSDocument> filesToBeSigned, Date signingDate, ASiCParameters asicParameters) {
        this.filesToBeSigned = filesToBeSigned;
        this.signingDate = signingDate;
        this.asicParameters = asicParameters;
    }

    @Override
    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters);
    }

    @Override
    public String getTimestampFilename() {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-S + XAdES");
    }

    @Override
    public List<DSSDocument> getToBeSigned() {
        return this.getSignedDocuments();
    }

    @Override
    public DSSDocument getExistingSignature() {
        return null;
    }

    @Override
    public List<DSSDocument> getSignedDocuments() {
        if (this.signedDocuments == null) {
            this.signedDocuments = Utils.collectionSize(this.filesToBeSigned) > 1 ? Arrays.asList(this.createPackageZip(this.filesToBeSigned, this.signingDate)) : new ArrayList<DSSDocument>(this.filesToBeSigned);
        }
        return this.signedDocuments;
    }

    @Override
    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getSignatures() {
        return new ArrayList<DSSDocument>();
    }

    @Override
    public DSSDocument getRootDocument() {
        return null;
    }
}

