/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignASiCEWithXAdESFromArchive;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignASiCEWithXAdESFromFiles;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignOpenDocument;
import eu.europa.esig.dss.asic.xades.signature.asics.DataToSignASiCSWithXAdESFromArchive;
import eu.europa.esig.dss.asic.xades.signature.asics.DataToSignASiCSWithXAdESFromFiles;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.List;

public class ASiCWithXAdESDataToSignHelperBuilder {
    private ASiCWithXAdESDataToSignHelperBuilder() {
    }

    public static GetDataToSignASiCWithXAdESHelper getGetDataToSignHelper(List<DSSDocument> documents, ASiCWithXAdESSignatureParameters parameters) {
        BLevelParameters bLevel = parameters.bLevel();
        boolean zip = ASiCUtils.isArchive(documents);
        boolean signedAsic = ASiCUtils.isAsic(documents);
        boolean asice = ASiCUtils.isASiCE(parameters.aSiC());
        if (zip) {
            DSSDocument archiveDoc = documents.get(0);
            ASiCWithXAdESContainerExtractor extractor = new ASiCWithXAdESContainerExtractor(archiveDoc);
            ASiCExtractResult extract = extractor.extract();
            boolean openDocument = ASiCUtils.isOpenDocument(extract.getMimeTypeDocument());
            if (openDocument) {
                return new DataToSignOpenDocument(extract.getSignedDocuments(), extract.getSignatureDocuments(), extract.getManifestDocuments(), extract.getMimeTypeDocument(), extract.getRootContainer());
            }
            if (signedAsic) {
                if (!ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension(archiveDoc, ".xml")) {
                    throw new UnsupportedOperationException("Container type doesn't match");
                }
                ASiCContainerType currentContainerType = ASiCUtils.getContainerType(archiveDoc, extract.getMimeTypeDocument(), extract.getZipComment(), extract.getSignedDocuments());
                if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                    return new DataToSignASiCEWithXAdESFromArchive(extract.getSignedDocuments(), extract.getSignatureDocuments(), extract.getManifestDocuments(), parameters.aSiC());
                }
                if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                    return new DataToSignASiCSWithXAdESFromArchive(extract.getSignatureDocuments(), extract.getSignedDocuments(), parameters.aSiC());
                }
                throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", new Object[]{currentContainerType, parameters.aSiC().getContainerType()}));
            }
            return ASiCWithXAdESDataToSignHelperBuilder.fromFiles(documents, parameters, bLevel, asice);
        }
        return ASiCWithXAdESDataToSignHelperBuilder.fromFiles(documents, parameters, bLevel, asice);
    }

    private static GetDataToSignASiCWithXAdESHelper fromFiles(List<DSSDocument> documents, ASiCWithXAdESSignatureParameters parameters, BLevelParameters bLevel, boolean asice) {
        if (asice) {
            return new DataToSignASiCEWithXAdESFromFiles(documents, parameters.aSiC());
        }
        return new DataToSignASiCSWithXAdESFromFiles(documents, bLevel.getSigningDate(), parameters.aSiC());
    }
}

