/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestParser;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESTimestampValidator;
import eu.europa.esig.dss.asic.cades.validation.CMSDocumentForASiCValidator;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESValidator
extends AbstractASiCContainerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESValidator.class);

    ASiCContainerWithCAdESValidator() {
        super((DSSDocument)null);
    }

    public ASiCContainerWithCAdESValidator(DSSDocument asicContainer) {
        super(asicContainer);
        this.analyseEntries();
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return ASiCUtils.isZip(dssDocument) && ASiCUtils.isASiCWithCAdES(dssDocument);
    }

    @Override
    protected AbstractASiCContainerExtractor getArchiveExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    @Override
    protected List<DocumentValidator> getSignatureValidators() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                CMSDocumentForASiCValidator cadesValidator = new CMSDocumentForASiCValidator(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setProcessExecutor(this.processExecutor);
                cadesValidator.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                cadesValidator.setDetachedContents(this.getSignedDocuments(signature));
                cadesValidator.setContainerContents(this.getArchiveDocuments());
                cadesValidator.setManifestFiles(this.getManifestFiles());
                this.signatureValidators.add(cadesValidator);
            }
        }
        return this.signatureValidators;
    }

    protected List<DocumentValidator> getTimestampValidators() {
        if (this.timestampValidators == null) {
            this.timestampValidators = new ArrayList();
            for (DSSDocument timestamp : this.getTimestampDocuments()) {
                DetachedTimestampValidator timestampValidator;
                DSSDocument archiveManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getAllManifestDocuments(), timestamp.getName());
                if (archiveManifest != null) {
                    ManifestFile validatedManifestFile = this.getValidatedManifestFile(archiveManifest);
                    if (validatedManifestFile != null) {
                        timestampValidator = new ASiCEWithCAdESTimestampValidator(timestamp, this.getTimestampType(validatedManifestFile), validatedManifestFile, this.getAllDocuments());
                        timestampValidator.setTimestampedData(archiveManifest);
                        timestampValidator.setCertificateVerifier(this.certificateVerifier);
                        this.timestampValidators.add(timestampValidator);
                        continue;
                    }
                    LOG.warn("A linked manifest is not found for a timestamp with name [{}]!", (Object)archiveManifest.getName());
                    continue;
                }
                List<DSSDocument> signedDocuments = this.getSignedDocuments();
                if (Utils.collectionSize(signedDocuments) == 1) {
                    timestampValidator = new DetachedTimestampValidator(timestamp);
                    timestampValidator.setTimestampedData(signedDocuments.get(0));
                    timestampValidator.setCertificateVerifier(this.certificateVerifier);
                    this.timestampValidators.add(timestampValidator);
                    continue;
                }
                LOG.warn("Timestamp {} is skipped (no linked archive manifest found / unique file)", (Object)timestamp.getName());
            }
        }
        return this.timestampValidators;
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        ArrayList<TimestampToken> independantTimestamps = new ArrayList<TimestampToken>();
        for (DocumentValidator timestampValidator : this.getTimestampValidators()) {
            independantTimestamps.addAll(timestampValidator.getDetachedTimestamps());
        }
        return independantTimestamps;
    }

    @Override
    public List<DSSDocument> getArchiveDocuments() {
        List<DSSDocument> archiveContents = super.getArchiveDocuments();
        if (Utils.isCollectionNotEmpty(this.getManifestDocuments())) {
            for (DSSDocument document : this.getAllDocuments()) {
                if (archiveContents.contains(document)) continue;
                archiveContents.add(document);
            }
        }
        return archiveContents;
    }

    @Override
    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ArrayList<TimestampToken> externalTimestamps = new ArrayList<TimestampToken>();
        List<DocumentValidator> currentTimestampValidators = this.getTimestampValidators();
        for (DocumentValidator tspValidator : currentTimestampValidators) {
            TimestampToken timestamp = this.getExternalTimestamp(tspValidator, allSignatures);
            if (timestamp == null) continue;
            externalTimestamps.add(timestamp);
        }
        return externalTimestamps;
    }

    private TimestampToken getExternalTimestamp(DocumentValidator tspValidator, List<AdvancedSignature> allSignatures) {
        if (tspValidator instanceof ASiCEWithCAdESTimestampValidator) {
            ASiCEWithCAdESTimestampValidator manifestBasedTimestampValidator = (ASiCEWithCAdESTimestampValidator)tspValidator;
            TimestampToken timestamp = manifestBasedTimestampValidator.getTimestamp();
            ManifestFile coveredManifest = manifestBasedTimestampValidator.getCoveredManifest();
            for (ManifestEntry entry : coveredManifest.getEntries()) {
                for (AdvancedSignature advancedSignature : allSignatures) {
                    if (!Utils.areStringsEqual(entry.getFileName(), advancedSignature.getSignatureFilename())) continue;
                    CAdESSignature cadesSig = (CAdESSignature)advancedSignature;
                    timestamp.setArchiveTimestampType(ArchiveTimestampType.CAdES_DETACHED);
                    cadesSig.addExternalTimestamp(timestamp);
                }
            }
            return timestamp;
        }
        if (tspValidator instanceof DetachedTimestampValidator) {
            return ((DetachedTimestampValidator)tspValidator).getTimestamp();
        }
        return null;
    }

    private ManifestFile getValidatedManifestFile(DSSDocument manifest) {
        List<ManifestFile> manifestFiles = this.getManifestFiles();
        if (Utils.isCollectionNotEmpty(manifestFiles)) {
            for (ManifestFile manifestFile : manifestFiles) {
                if (!Utils.areStringsEqual(manifest.getName(), manifestFile.getFilename())) continue;
                return manifestFile;
            }
        }
        return null;
    }

    private TimestampType getTimestampType(ManifestFile manifestFile) {
        return this.coversSignature(manifestFile) ? TimestampType.ARCHIVE_TIMESTAMP : TimestampType.CONTENT_TIMESTAMP;
    }

    private boolean coversSignature(ManifestFile manifestFile) {
        for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
            if (!ASiCUtils.isSignature(manifestEntry.getFileName())) continue;
            return true;
        }
        return false;
    }

    private List<DSSDocument> getSignedDocuments(DSSDocument signature) {
        ASiCContainerType type = this.getContainerType();
        if (ASiCContainerType.ASiC_S.equals((Object)type)) {
            return this.getSignedDocuments();
        }
        if (ASiCContainerType.ASiC_E.equals((Object)type)) {
            DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getManifestDocuments(), signature.getName());
            if (linkedManifest != null) {
                return Arrays.asList(linkedManifest);
            }
            return Collections.singletonList(new InMemoryDocument(new byte[0]));
        }
        LOG.warn("Unknown asic container type (returns all signed documents)");
        return this.getAllDocuments();
    }

    @Override
    protected List<ManifestFile> getManifestFilesDecriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List<DSSDocument> manifestDocuments = this.getManifestDocuments();
        for (DSSDocument manifestDocument : manifestDocuments) {
            ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List<DSSDocument> archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setArchiveManifest(true);
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        List<AdvancedSignature> signatures = this.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!signature.getId().equals(signatureId)) continue;
            return this.getOriginalDocuments(signature);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        if (advancedSignature.isCounterSignature()) {
            CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        List<DSSDocument> retrievedDocs = advancedSignature.getDetachedContents();
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getManifestDocuments(), advancedSignature.getSignatureFilename());
        if (linkedManifest == null) {
            return Collections.emptyList();
        }
        ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(linkedManifest);
        List<ManifestEntry> entries = manifestFile.getEntries();
        List<DSSDocument> signedDocuments = this.getAllDocuments();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ManifestEntry entry : entries) {
            for (DSSDocument signedDocument : signedDocuments) {
                if (!Utils.areStringsEqual(entry.getFileName(), signedDocument.getName())) continue;
                result.add(signedDocument);
            }
        }
        return result;
    }
}

