/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.PastCertificateValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.CurrentTimeIndicationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.POEExistsCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks.PastCertificateValidationAcceptableCheck;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PastSignatureValidation
extends Chain<XmlPSV> {
    private final TokenProxy token;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;

    public PastSignatureValidation(I18nProvider i18nProvider, TokenProxy token, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(i18nProvider, new XmlPSV());
        this.token = token;
        this.bbbs = bbbs;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.PAST_SIGNATURE_VALIDATION;
    }

    @Override
    protected void initChain() {
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.token.getId());
        Indication currentTimeIndication = tokenBBB.getConclusion().getIndication();
        SubIndication currentTimeSubIndication = tokenBBB.getConclusion().getSubIndication();
        List<XmlName> currentTimeErrors = tokenBBB.getConclusion().getErrors();
        PastCertificateValidation pcv = new PastCertificateValidation(this.i18nProvider, this.token, tokenBBB, this.poe, this.currentTime, this.policy, this.context);
        XmlPCV pcvResult = (XmlPCV)pcv.execute();
        tokenBBB.setPCV(pcvResult);
        ChainItem<XmlPSV> item = this.firstItem = this.pastCertificateValidationAcceptableCheck(pcvResult);
        Date controlTime = pcvResult.getControlTime();
        if (controlTime != null && this.poe.isPOEExists(this.token.getId(), controlTime)) {
            ((XmlPSV)this.result).setControlTime(controlTime);
            if (Indication.INDETERMINATE.equals(currentTimeIndication) && (SubIndication.REVOKED_NO_POE.equals(currentTimeSubIndication) || SubIndication.REVOKED_CA_NO_POE.equals(currentTimeSubIndication))) {
                item = item.setNextItem(this.poeExist());
                return;
            }
            if (Indication.INDETERMINATE.equals(currentTimeIndication) && (SubIndication.OUT_OF_BOUNDS_NO_POE.equals(currentTimeSubIndication) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(currentTimeSubIndication))) {
                Date bestSignatureTime = this.poe.getLowestPOETime(this.token.getId());
                CertificateWrapper signingCertificate = this.token.getSigningCertificate();
                item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime, signingCertificate));
                item = item.setNextItem(this.bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(bestSignatureTime, signingCertificate, currentTimeSubIndication));
                return;
            }
        }
        if (Indication.INDETERMINATE.equals(currentTimeIndication) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(currentTimeSubIndication)) {
            item = item.setNextItem(this.tokenUsedAlgorithmsAreSecureAtPoeTime(this.token, this.context));
            item = this.certificateChainReliableAtPoeTime(item, this.context);
            return;
        }
        item = item.setNextItem(this.currentTimeIndicationCheck(currentTimeIndication, currentTimeSubIndication, currentTimeErrors));
    }

    private ChainItem<XmlPSV> currentTimeIndicationCheck(Indication currentTimeIndication, SubIndication currentTimeSubIndication, List<XmlName> currentTimeErrors) {
        return new CurrentTimeIndicationCheck(this.i18nProvider, (XmlPSV)this.result, currentTimeIndication, currentTimeSubIndication, currentTimeErrors, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> pastCertificateValidationAcceptableCheck(XmlPCV pcvResult) {
        return new PastCertificateValidationAcceptableCheck(this.i18nProvider, (XmlPSV)this.result, pcvResult, this.token.getId(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> poeExist() {
        return new POEExistsCheck(this.i18nProvider, (XmlPSV)this.result, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime, CertificateWrapper signingCertificate) {
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPSV> bestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpiration(Date bestSignatureTime, CertificateWrapper signingCertificate, SubIndication currentTimeSubIndication) {
        return new BestSignatureTimeAfterCertificateIssuanceAndBeforeCertificateExpirationCheck(this.i18nProvider, (XmlPSV)this.result, bestSignatureTime, signingCertificate, currentTimeSubIndication, this.getFailLevelConstraint());
    }

    private CryptographicCheck<XmlPSV> tokenUsedAlgorithmsAreSecureAtPoeTime(TokenProxy currentToken, Context context) {
        CryptographicConstraint cryptographicConstraint = this.policy.getSignatureCryptographicConstraint(context);
        return new CryptographicCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, currentToken, this.getLowestPoeTime(this.token), cryptographicConstraint);
    }

    private ChainItem<XmlPSV> certificateChainReliableAtPoeTime(ChainItem<XmlPSV> item, Context context) {
        return this.certificateChainReliableAtPoeTime(item, this.token.getCertificateChain(), context, new ArrayList<String>());
    }

    private ChainItem<XmlPSV> certificateChainReliableAtPoeTime(ChainItem<XmlPSV> item, List<CertificateWrapper> certificateChain, Context context, List<String> checkedTokens) {
        for (CertificateWrapper certificate : certificateChain) {
            if (certificate.isTrusted()) break;
            if (checkedTokens.contains(certificate.getId())) continue;
            checkedTokens.add(certificate.getId());
            SubContext subContext = this.token.getSigningCertificate().getId().equals(certificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            item = item.setNextItem(new CryptographicCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, certificate, this.getLowestPoeTime(certificate), this.policy.getCertificateCryptographicConstraint(context, subContext)));
            CertificateRevocationWrapper latestAcceptableRevocation = ValidationProcessUtils.getLatestAcceptableRevocationData(certificate, this.bbbs.get(this.token.getId()));
            if (latestAcceptableRevocation == null || checkedTokens.contains(latestAcceptableRevocation.getId())) continue;
            checkedTokens.add(latestAcceptableRevocation.getId());
            item = item.setNextItem(new CryptographicCheck<XmlPSV>(this.i18nProvider, (XmlPSV)this.result, latestAcceptableRevocation, this.getLowestPoeTime(latestAcceptableRevocation), this.policy.getSignatureCryptographicConstraint(Context.REVOCATION)));
            item = this.certificateChainReliableAtPoeTime(item, latestAcceptableRevocation.getCertificateChain(), Context.REVOCATION, checkedTokens);
        }
        return item;
    }

    private Date getLowestPoeTime(TokenProxy token) {
        return this.poe.getLowestPOETime(token.getId());
    }
}

