/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class SignatureIntactCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TokenProxy token;
    private final Context context;

    public SignatureIntactCheck(I18nProvider i18nProvider, T result, TokenProxy token, Context context, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.token = token;
        this.context = context;
    }

    @Override
    protected boolean process() {
        return this.token.isSignatureIntact();
    }

    @Override
    protected MessageTag getMessageTag() {
        switch (this.context) {
            case CERTIFICATE: {
                return MessageTag.BBB_CV_ISIC;
            }
            case REVOCATION: {
                return MessageTag.BBB_CV_ISIR;
            }
            case TIMESTAMP: {
                return MessageTag.BBB_CV_ISIT;
            }
        }
        return MessageTag.BBB_CV_ISI;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_ISI_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CRYPTO_FAILURE;
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        return MessageTag.TOKEN_ID.setArgs(this.token.getId());
    }
}

