/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIACertificateSource
extends CommonCertificateSource {
    private static final long serialVersionUID = -2604947158902474169L;
    private static final Logger LOG = LoggerFactory.getLogger(AIACertificateSource.class);
    private final CertificateToken certificate;
    private final DataLoader dataLoader;

    public AIACertificateSource(CertificateToken certificate, DataLoader dataLoader) {
        Objects.requireNonNull(certificate, "The certificate cannot be null");
        Objects.requireNonNull(dataLoader, "The data loader cannot be null");
        this.certificate = certificate;
        this.dataLoader = dataLoader;
    }

    public CertificateToken getIssuerFromAIA() {
        LOG.info("Retrieving {} certificate's issuer using AIA.", (Object)this.certificate.getAbbreviation());
        Collection<CertificateToken> candidates = DSSUtils.loadPotentialIssuerCertificates(this.certificate, this.dataLoader);
        if (Utils.isCollectionNotEmpty(candidates)) {
            CertificateToken bridgedIssuer = this.findBestBridgeCertificate(candidates);
            if (bridgedIssuer != null) {
                this.addCertificate(bridgedIssuer);
                return bridgedIssuer;
            }
            for (CertificateToken candidate : candidates) {
                this.addCertificate(candidate);
            }
            for (CertificateToken candidate : candidates) {
                if (!this.certificate.isSignedBy(candidate)) continue;
                if (!this.certificate.getIssuerX500Principal().equals(candidate.getSubject().getPrincipal())) {
                    LOG.info("There is AIA extension, but the issuer subject name and subject name does not match.");
                    LOG.info("CERT ISSUER    : {}", (Object)this.certificate.getIssuer().getCanonical());
                    LOG.info("ISSUER SUBJECT : {}", (Object)candidate.getSubject().getCanonical());
                }
                return candidate;
            }
            LOG.warn("The retrieved certificate(s) using AIA does not sign the certificate {}.", (Object)this.certificate.getAbbreviation());
        }
        return null;
    }

    private CertificateToken findBestBridgeCertificate(Collection<CertificateToken> candidates) {
        if (Utils.collectionSize(candidates) <= 1) {
            return null;
        }
        PublicKey commonPublicKey = null;
        CertificateToken bestMatch = null;
        for (CertificateToken candidate : candidates) {
            PublicKey candidatePublicKey = candidate.getPublicKey();
            if (commonPublicKey == null) {
                if (!this.certificate.isSignedBy(candidate)) {
                    return null;
                }
                commonPublicKey = candidatePublicKey;
                bestMatch = candidate;
                continue;
            }
            if (!candidatePublicKey.equals(commonPublicKey)) {
                return null;
            }
            if (!this.isTrusted(bestMatch)) continue;
        }
        return bestMatch;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.AIA;
    }
}

