/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.FileDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.standalone.RemoteDocumentSignatureServiceBuilder;
import eu.europa.esig.dss.standalone.exception.ApplicationException;
import eu.europa.esig.dss.standalone.model.SignatureModel;
import eu.europa.esig.dss.standalone.task.SelectCertificateTask;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.MSCAPISignatureToken;
import eu.europa.esig.dss.token.Pkcs11SignatureToken;
import eu.europa.esig.dss.token.Pkcs12SignatureToken;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteBLevelParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.concurrent.Task;

public class SigningTask
extends Task<DSSDocument> {
    private final SignatureModel model;
    private final RemoteDocumentSignatureService service;

    public SigningTask(SignatureModel model, TrustedListsCertificateSource tslCertificateSource) {
        this.model = model;
        RemoteDocumentSignatureServiceBuilder builder = new RemoteDocumentSignatureServiceBuilder();
        builder.setTslCertificateSource(tslCertificateSource);
        this.service = builder.build();
    }

    @Override
    protected DSSDocument call() throws Exception {
        this.updateProgress(0L, 100L);
        SignatureTokenConnection token = this.getToken(this.model);
        this.updateProgress(5L, 100L);
        List<DSSPrivateKeyEntry> keys = token.getKeys();
        this.updateProgress(10L, 100L);
        DSSPrivateKeyEntry signer = this.getSigner(keys);
        FileDocument fileToSign = new FileDocument(this.model.getFileToSign());
        RemoteDocument toSignDocument = RemoteDocumentConverter.toRemoteDocument(fileToSign);
        RemoteSignatureParameters parameters = this.buildParameters(signer);
        ToBeSigned toBeSigned = this.getDataToSign(toSignDocument, parameters);
        SignatureValue signatureValue = this.signDigest(token, signer, toBeSigned);
        DSSDocument signDocument = this.signDocument(toSignDocument, parameters, signatureValue);
        this.updateProgress(100L, 100L);
        return signDocument;
    }

    private RemoteSignatureParameters buildParameters(DSSPrivateKeyEntry signer) {
        this.updateProgress(20L, 100L);
        RemoteSignatureParameters parameters = new RemoteSignatureParameters();
        parameters.setAsicContainerType(this.model.getAsicContainerType());
        parameters.setDigestAlgorithm(this.model.getDigestAlgorithm());
        parameters.setSignatureLevel(this.model.getSignatureLevel());
        parameters.setSignaturePackaging(this.model.getSignaturePackaging());
        RemoteBLevelParameters bLevelParams = new RemoteBLevelParameters();
        bLevelParams.setSigningDate(new Date());
        parameters.setBLevelParams(bLevelParams);
        parameters.setSigningCertificate(new RemoteCertificate(signer.getCertificate().getEncoded()));
        parameters.setEncryptionAlgorithm(signer.getEncryptionAlgorithm());
        Object[] certificateChain = signer.getCertificateChain();
        if (Utils.isArrayNotEmpty(certificateChain)) {
            ArrayList<RemoteCertificate> certificateChainList = new ArrayList<RemoteCertificate>();
            for (Object certificateToken : certificateChain) {
                certificateChainList.add(new RemoteCertificate(((CertificateToken)certificateToken).getEncoded()));
            }
            parameters.setCertificateChain(certificateChainList);
        }
        return parameters;
    }

    private ToBeSigned getDataToSign(RemoteDocument toSignDocument, RemoteSignatureParameters parameters) {
        this.updateProgress(25L, 100L);
        ToBeSigned toBeSigned = null;
        try {
            toBeSigned = DTOConverter.toToBeSigned(this.service.getDataToSign(toSignDocument, parameters));
        }
        catch (Exception e) {
            this.throwException("Unable to compute the digest to sign", e);
        }
        return toBeSigned;
    }

    private SignatureValue signDigest(SignatureTokenConnection token, DSSPrivateKeyEntry signer, ToBeSigned toBeSigned) {
        this.updateProgress(50L, 100L);
        SignatureValue signatureValue = null;
        try {
            signatureValue = token.sign(toBeSigned, this.model.getDigestAlgorithm(), signer);
        }
        catch (Exception e) {
            this.throwException("Unable to sign the digest", e);
        }
        return signatureValue;
    }

    private DSSDocument signDocument(RemoteDocument toSignDocument, RemoteSignatureParameters parameters, SignatureValue signatureValue) {
        this.updateProgress(75L, 100L);
        DSSDocument signDocument = null;
        try {
            signDocument = RemoteDocumentConverter.toDSSDocument(this.service.signDocument(toSignDocument, parameters, new SignatureValueDTO(signatureValue.getAlgorithm(), signatureValue.getValue())));
        }
        catch (Exception e) {
            this.throwException("Unable to sign the document", e);
        }
        return signDocument;
    }

    private DSSPrivateKeyEntry getSigner(List<DSSPrivateKeyEntry> keys) throws Exception {
        DSSPrivateKeyEntry selectedKey = null;
        if (Utils.isCollectionEmpty(keys)) {
            this.throwException("No certificate found", null);
        } else if (Utils.collectionSize(keys) == 1) {
            selectedKey = keys.get(0);
        } else {
            FutureTask<DSSPrivateKeyEntry> future = new FutureTask<DSSPrivateKeyEntry>(new SelectCertificateTask(keys));
            Platform.runLater(future);
            selectedKey = future.get();
            if (selectedKey == null) {
                this.throwException("No selected certificate", null);
            }
        }
        return selectedKey;
    }

    private SignatureTokenConnection getToken(SignatureModel model) throws IOException {
        switch (model.getTokenType()) {
            case PKCS11: {
                return new Pkcs11SignatureToken(model.getPkcsFile().getAbsolutePath(), new KeyStore.PasswordProtection(model.getPassword().toCharArray()));
            }
            case PKCS12: {
                return new Pkcs12SignatureToken(model.getPkcsFile(), new KeyStore.PasswordProtection(model.getPassword().toCharArray()));
            }
            case MSCAPI: {
                return new MSCAPISignatureToken();
            }
        }
        throw new IllegalArgumentException("Unsupported token type " + model.getTokenType());
    }

    private void throwException(String message, Exception e) {
        String exceptionMessage = message + (String)(e != null ? " : " + e.getMessage() : "");
        this.updateMessage(exceptionMessage);
        this.failed();
        throw new ApplicationException(exceptionMessage, e);
    }
}

