/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.service.http.commons.CommonsDataLoader;
import eu.europa.esig.dss.service.http.commons.FileCacheDataLoader;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.client.http.IgnoreDataLoader;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.KeyStoreCertificateSource;
import eu.europa.esig.dss.tsl.cache.CacheCleaner;
import eu.europa.esig.dss.tsl.function.OfficialJournalSchemeInformationURI;
import eu.europa.esig.dss.tsl.job.TLValidationJob;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.sync.AcceptAllStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JobBuilder.class);
    private Properties prop;
    private TrustedListsCertificateSource tslCertificateSource = new TrustedListsCertificateSource();
    private File cacheDirectory;

    public JobBuilder() {
        this.getProperties();
        this.cacheDirectory = this.tlCacheDirectory();
    }

    private void getProperties() {
        this.prop = new Properties();
        try (InputStream is = JobBuilder.class.getResourceAsStream("/app.config");){
            this.prop.load(is);
        }
        catch (IOException e) {
            LOG.warn("Could not load properties file : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public TLValidationJob job() {
        TLValidationJob job = new TLValidationJob();
        job.setOnlineDataLoader(this.onlineLoader());
        job.setOfflineDataLoader(this.offlineLoader());
        job.setTrustedListCertificateSource(this.tslCertificateSource);
        job.setSynchronizationStrategy(new AcceptAllStrategy());
        job.setCacheCleaner(this.cacheCleaner());
        LOTLSource europeanLOTL = this.europeanLOTL();
        job.setListOfTrustedListSources(europeanLOTL);
        return job;
    }

    private DSSFileLoader onlineLoader() {
        FileCacheDataLoader onlineFileLoader = new FileCacheDataLoader();
        onlineFileLoader.setCacheExpirationTime(0L);
        onlineFileLoader.setDataLoader(this.dataLoader());
        onlineFileLoader.setFileCacheDirectory(this.cacheDirectory);
        return onlineFileLoader;
    }

    private DSSFileLoader offlineLoader() {
        FileCacheDataLoader offlineFileLoader = new FileCacheDataLoader();
        offlineFileLoader.setCacheExpirationTime(Long.MAX_VALUE);
        offlineFileLoader.setDataLoader(new IgnoreDataLoader());
        offlineFileLoader.setFileCacheDirectory(this.cacheDirectory);
        return offlineFileLoader;
    }

    private CommonsDataLoader dataLoader() {
        return new CommonsDataLoader();
    }

    private LOTLSource europeanLOTL() {
        LOTLSource lotlSource = new LOTLSource();
        lotlSource.setUrl(this.prop.getProperty("lotl.url"));
        lotlSource.setCertificateSource(this.officialJournalContentKeyStore());
        lotlSource.setSigningCertificatesAnnouncementPredicate(new OfficialJournalSchemeInformationURI(this.prop.getProperty("oj.url")));
        lotlSource.setPivotSupport(true);
        return lotlSource;
    }

    private CacheCleaner cacheCleaner() {
        CacheCleaner cacheCleaner = new CacheCleaner();
        cacheCleaner.setCleanMemory(true);
        cacheCleaner.setCleanFileSystem(true);
        cacheCleaner.setDSSFileLoader(this.getDSSFileLoader());
        return cacheCleaner;
    }

    private CertificateSource officialJournalContentKeyStore() {
        return new KeyStoreCertificateSource(JobBuilder.class.getResourceAsStream(this.prop.getProperty("keystore.path")), this.prop.getProperty("keystore.type"), this.prop.getProperty("keystore.password"));
    }

    private FileCacheDataLoader getDSSFileLoader() {
        FileCacheDataLoader fileLoader = new FileCacheDataLoader();
        fileLoader.setCacheExpirationTime(0L);
        fileLoader.setFileCacheDirectory(this.cacheDirectory);
        return fileLoader;
    }

    private File tlCacheDirectory() {
        File rootFolder = new File(System.getProperty("java.io.tmpdir"));
        File tslCache = new File(rootFolder, "dss-tsl-loader");
        LOG.info("TL Cache folder : {}", (Object)tslCache.getAbsolutePath());
        return tslCache;
    }

    public TrustedListsCertificateSource getCertificateSources() {
        return this.tslCertificateSource;
    }
}

