/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.crl;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.crl.CRLValidity;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLTokenRefMatcher;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OfflineCRLSource
extends OfflineRevocationSource<CRL> {
    private static final Logger LOG = LoggerFactory.getLogger(OfflineCRLSource.class);

    protected OfflineCRLSource() {
        super(new CRLTokenRefMatcher());
    }

    @Override
    public List<RevocationToken<CRL>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerToken) {
        Objects.requireNonNull(certificateToken, "The certificate to be verified cannot be null");
        Objects.requireNonNull(issuerToken, "The issuer of the certificate to be verified cannot be null");
        ArrayList<RevocationToken<CRL>> result = new ArrayList<RevocationToken<CRL>>();
        Set<EncapsulatedRevocationTokenIdentifier> collectedBinaries = this.getAllRevocationBinaries();
        LOG.trace("--> OfflineCRLSource queried for {} contains: {} element(s).", (Object)certificateToken.getDSSIdAsString(), (Object)collectedBinaries.size());
        for (EncapsulatedRevocationTokenIdentifier binary : collectedBinaries) {
            CRLBinary crlBinary = (CRLBinary)binary;
            try {
                CRLValidity crlValidity = CRLUtils.buildCRLValidity(crlBinary, issuerToken);
                if (!crlValidity.isValid() || !this.isInCertificateValidityRange(crlValidity, certificateToken)) continue;
                CRLToken crlToken = new CRLToken(certificateToken, crlValidity);
                this.addRevocation(crlToken, crlBinary);
                result.add(crlToken);
            }
            catch (Exception e) {
                LOG.warn("Unable to retrieve the CRLValidity for CRL with ID '{}' : {}", (Object)crlBinary.asXmlId(), (Object)e.getMessage());
            }
        }
        LOG.trace("--> OfflineCRLSource found result(s) : {}", (Object)result.size());
        return result;
    }

    private boolean isInCertificateValidityRange(CRLValidity crlValidity, CertificateToken certificateToken) {
        boolean periodAreIntersecting;
        Date thisUpdate = crlValidity.getThisUpdate();
        Date nextUpdate = crlValidity.getNextUpdate();
        Date notAfter = certificateToken.getNotAfter();
        Date notBefore = certificateToken.getNotBefore();
        boolean bl = periodAreIntersecting = thisUpdate.compareTo(notAfter) <= 0 && nextUpdate != null && nextUpdate.compareTo(notBefore) >= 0;
        if (!periodAreIntersecting) {
            LOG.warn("The CRL was not issued during the validity period of the certificate! Certificate: {}", (Object)certificateToken.getDSSIdAsString());
            return false;
        }
        return true;
    }
}

