/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.pdf.pdfbox.visible.AbstractPdfBoxSignatureDrawer;
import eu.europa.esig.dss.pdf.pdfbox.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.DefaultDrawerImageUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.SignatureImageAndPosition;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.SignatureImageAndPositionProcessor;
import eu.europa.esig.dss.pdf.visible.CommonDrawerUtils;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSigProperties;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.visible.PDVisibleSignDesigner;

public class DefaultPdfBoxVisibleSignatureDrawer
extends AbstractPdfBoxSignatureDrawer {
    @Override
    public void draw() throws IOException {
        ImageAndResolution ires = DefaultDrawerImageUtils.create(this.parameters);
        SignatureImageAndPosition signatureImageAndPosition = SignatureImageAndPositionProcessor.process(this.parameters, this.document, ires);
        PDVisibleSignDesigner visibleSig = new PDVisibleSignDesigner(this.document, (InputStream)new ByteArrayInputStream(signatureImageAndPosition.getSignatureImage()), this.parameters.getPage());
        visibleSig.xAxis(signatureImageAndPosition.getX());
        visibleSig.yAxis(signatureImageAndPosition.getY());
        float width = this.parameters.getWidth();
        float height = this.parameters.getHeight();
        if (ImageRotationUtils.isSwapOfDimensionsRequired(signatureImageAndPosition.getGlobalRotation())) {
            width = this.parameters.getHeight();
            height = this.parameters.getWidth();
        }
        if (width != 0.0f) {
            visibleSig.width(width);
        } else if (this.parameters.getTextParameters() != null) {
            visibleSig.width(CommonDrawerUtils.toDpiAxisPoint(visibleSig.getWidth(), CommonDrawerUtils.getDpi(this.parameters.getDpi())));
        } else {
            visibleSig.width(ires.toXPoint(visibleSig.getWidth()));
        }
        if (height != 0.0f) {
            visibleSig.height(height);
        } else if (this.parameters.getTextParameters() != null) {
            visibleSig.height(CommonDrawerUtils.toDpiAxisPoint(visibleSig.getHeight(), CommonDrawerUtils.getDpi(this.parameters.getDpi())));
        } else {
            visibleSig.height(ires.toYPoint(visibleSig.getHeight()));
        }
        visibleSig.zoom((float)this.parameters.getZoom() - 100.0f);
        PDVisibleSigProperties signatureProperties = new PDVisibleSigProperties();
        signatureProperties.visualSignEnabled(true);
        signatureProperties.setPdVisibleSignature(visibleSig);
        signatureProperties.buildSignature();
        this.signatureOptions.setVisualSignature(signatureProperties);
        this.signatureOptions.setPage(this.parameters.getPage() - 1);
    }

    @Override
    protected String getColorSpaceName(DSSDocument image) throws IOException {
        return COSName.DEVICERGB.getName();
    }
}

