/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.pdf.AbstractPdfDssDict;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfVRIDict;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleDssDict
extends AbstractPdfDssDict {
    private static final Logger LOG = LoggerFactory.getLogger(SingleDssDict.class);
    private List<PdfVRIDict> vris;

    public static SingleDssDict extract(PdfDict documentDict) {
        PdfDict dssCatalog;
        if (documentDict != null && (dssCatalog = documentDict.getAsDict("DSS")) != null) {
            return new SingleDssDict(dssCatalog);
        }
        LOG.debug("No DSS dictionary found");
        return null;
    }

    protected SingleDssDict(PdfDict dssDictionary) {
        super(dssDictionary);
        this.readVRI(dssDictionary);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readVRI(PdfDict dssDictionary) {
        PdfDict vriDict = dssDictionary.getAsDict("VRI");
        if (vriDict != null) {
            LOG.debug("There is a VRI dictionary in DSS dictionary");
            try {
                Object[] names = vriDict.list();
                if (!Utils.isArrayNotEmpty(names)) return;
                this.vris = new ArrayList<PdfVRIDict>();
                for (Object name : names) {
                    this.vris.add(new PdfVRIDict((String)name, vriDict.getAsDict((String)name)));
                }
                return;
            }
            catch (Exception e) {
                LOG.debug("Unable to analyse VRI dictionary : {}", (Object)e.getMessage());
                return;
            }
        } else {
            LOG.debug("No VRI dictionary found in DSS dictionary");
        }
    }

    @Override
    protected String getDictionaryName() {
        return "DSS";
    }

    @Override
    protected String getCertArrayDictionaryName() {
        return "Certs";
    }

    @Override
    protected String getCRLArrayDictionaryName() {
        return "CRLs";
    }

    @Override
    protected String getOCSPArrayDictionaryName() {
        return "OCSPs";
    }

    @Override
    public List<PdfVRIDict> getVRIs() {
        return this.vris;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.vris != null) {
            result = 31 * result + this.vris.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleDssDict other = (SingleDssDict)obj;
        return !(this.vris == null ? other.vris != null : !this.vris.equals(other.vris));
    }
}

