/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.OidAndUriBasedEnum;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.spec.PSSParameterSpec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum SignatureAlgorithm implements OidAndUriBasedEnum
{
    RSA_RAW(EncryptionAlgorithm.RSA, null),
    RSA_SHA1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA1),
    RSA_SHA224(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA224),
    RSA_SHA256(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA256),
    RSA_SHA384(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA384),
    RSA_SHA512(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA512),
    RSA_SHA3_224(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_224),
    RSA_SHA3_256(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_256),
    RSA_SHA3_384(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_384),
    RSA_SHA3_512(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_512),
    RSA_SSA_PSS_RAW_MGF1(EncryptionAlgorithm.RSA, null, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA1_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA1, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA224_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA224, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA256_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA256, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA384_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA384, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA512_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA512, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA3_224_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_224, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA3_256_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_256, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA3_384_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_384, MaskGenerationFunction.MGF1),
    RSA_SSA_PSS_SHA3_512_MGF1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA3_512, MaskGenerationFunction.MGF1),
    RSA_RIPEMD160(EncryptionAlgorithm.RSA, DigestAlgorithm.RIPEMD160),
    RSA_MD5(EncryptionAlgorithm.RSA, DigestAlgorithm.MD5),
    RSA_MD2(EncryptionAlgorithm.RSA, DigestAlgorithm.MD2),
    ECDSA_RAW(EncryptionAlgorithm.ECDSA, null),
    ECDSA_SHA1(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA1),
    ECDSA_SHA224(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA224),
    ECDSA_SHA256(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA256),
    ECDSA_SHA384(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA384),
    ECDSA_SHA512(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA512),
    ECDSA_SHA3_224(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA3_224),
    ECDSA_SHA3_256(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA3_256),
    ECDSA_SHA3_384(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA3_384),
    ECDSA_SHA3_512(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA3_512),
    ECDSA_RIPEMD160(EncryptionAlgorithm.ECDSA, DigestAlgorithm.RIPEMD160),
    PLAIN_ECDSA_SHA1(EncryptionAlgorithm.PLAIN_ECDSA, DigestAlgorithm.SHA1),
    PLAIN_ECDSA_SHA224(EncryptionAlgorithm.PLAIN_ECDSA, DigestAlgorithm.SHA224),
    PLAIN_ECDSA_SHA256(EncryptionAlgorithm.PLAIN_ECDSA, DigestAlgorithm.SHA256),
    PLAIN_ECDSA_SHA384(EncryptionAlgorithm.PLAIN_ECDSA, DigestAlgorithm.SHA384),
    PLAIN_ECDSA_SHA512(EncryptionAlgorithm.PLAIN_ECDSA, DigestAlgorithm.SHA512),
    PLAIN_ECDSA_RIPEMD160(EncryptionAlgorithm.PLAIN_ECDSA, DigestAlgorithm.RIPEMD160),
    DSA_RAW(EncryptionAlgorithm.DSA, null),
    DSA_SHA1(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA1),
    DSA_SHA224(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA224),
    DSA_SHA256(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA256),
    DSA_SHA384(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA384),
    DSA_SHA512(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA512),
    DSA_SHA3_224(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA3_224),
    DSA_SHA3_256(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA3_256),
    DSA_SHA3_384(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA3_384),
    DSA_SHA3_512(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA3_512),
    HMAC_SHA1(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA1),
    HMAC_SHA224(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA224),
    HMAC_SHA256(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA256),
    HMAC_SHA384(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA384),
    HMAC_SHA512(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA512),
    HMAC_SHA3_224(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA3_224),
    HMAC_SHA3_256(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA3_256),
    HMAC_SHA3_384(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA3_384),
    HMAC_SHA3_512(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA3_512),
    HMAC_RIPEMD160(EncryptionAlgorithm.HMAC, DigestAlgorithm.RIPEMD160),
    ED25519(EncryptionAlgorithm.ED25519, DigestAlgorithm.SHA512),
    ED448(EncryptionAlgorithm.ED448, DigestAlgorithm.SHAKE256_512);

    private final EncryptionAlgorithm encryptionAlgo;
    private final DigestAlgorithm digestAlgo;
    private final MaskGenerationFunction maskGenerationFunction;
    private static final String OID_NAMESPACE_PREFIX = "urn:oid:";
    private static final String UNSUPPORTED_ALGO_MSG = "Unsupported algorithm: %s";
    private static final Map<String, SignatureAlgorithm> XML_ALGORITHMS;
    private static final Map<SignatureAlgorithm, String> XML_ALGORITHMS_FOR_KEY;
    private static final Map<String, SignatureAlgorithm> OID_ALGORITHMS;
    private static final Map<SignatureAlgorithm, String> OID_ALGORITHMS_FOR_KEY;
    private static final Map<String, SignatureAlgorithm> JAVA_ALGORITHMS;
    private static final Map<SignatureAlgorithm, String> JAVA_ALGORITHMS_FOR_KEY;

    private static Map<String, SignatureAlgorithm> registerXmlAlgorithms() {
        HashMap<String, SignatureAlgorithm> xmlAlgorithms = new HashMap<String, SignatureAlgorithm>();
        xmlAlgorithms.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", RSA_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", RSA_SHA224);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", RSA_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", RSA_SHA384);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", RSA_SHA512);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", RSA_SSA_PSS_SHA1_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", RSA_SSA_PSS_SHA224_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", RSA_SSA_PSS_SHA256_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", RSA_SSA_PSS_SHA384_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", RSA_SSA_PSS_SHA512_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", RSA_SSA_PSS_SHA3_224_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", RSA_SSA_PSS_SHA3_256_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", RSA_SSA_PSS_SHA3_384_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", RSA_SSA_PSS_SHA3_512_MGF1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", RSA_RIPEMD160);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", RSA_RIPEMD160);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-md5", RSA_MD5);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", ECDSA_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", ECDSA_SHA224);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", ECDSA_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", ECDSA_SHA384);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", ECDSA_SHA512);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", ECDSA_RIPEMD160);
        xmlAlgorithms.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", DSA_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2009/xmldsig11#dsa-sha256", DSA_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2000/09/xmldsig#hmac-sha1", HMAC_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224", HMAC_SHA224);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", HMAC_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", HMAC_SHA384);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", HMAC_SHA512);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", HMAC_RIPEMD160);
        return xmlAlgorithms;
    }

    private static Map<SignatureAlgorithm, String> registerXmlAlgorithmsForKey() {
        EnumMap<SignatureAlgorithm, String> xmlAlgorithms = new EnumMap<SignatureAlgorithm, String>(SignatureAlgorithm.class);
        for (Map.Entry<String, SignatureAlgorithm> entry : XML_ALGORITHMS.entrySet()) {
            xmlAlgorithms.put(entry.getValue(), entry.getKey());
        }
        return xmlAlgorithms;
    }

    private static Map<String, SignatureAlgorithm> registerOIDAlgorithms() {
        HashMap<String, SignatureAlgorithm> oidAlgorithms = new HashMap<String, SignatureAlgorithm>();
        oidAlgorithms.put("1.2.840.113549.1.1.5", RSA_SHA1);
        oidAlgorithms.put("1.3.14.3.2.29", RSA_SHA1);
        oidAlgorithms.put("1.2.840.113549.1.1.14", RSA_SHA224);
        oidAlgorithms.put("1.2.840.113549.1.1.11", RSA_SHA256);
        oidAlgorithms.put("1.2.840.113549.1.1.12", RSA_SHA384);
        oidAlgorithms.put("1.2.840.113549.1.1.13", RSA_SHA512);
        oidAlgorithms.put("1.3.36.3.3.1.2", RSA_RIPEMD160);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.13", RSA_SHA3_224);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.14", RSA_SHA3_256);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.15", RSA_SHA3_384);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.16", RSA_SHA3_512);
        oidAlgorithms.put("1.2.840.113549.1.1.4", RSA_MD5);
        oidAlgorithms.put("1.2.840.113549.1.1.2", RSA_MD2);
        oidAlgorithms.put("1.2.840.10045.4.1", ECDSA_SHA1);
        oidAlgorithms.put("1.2.840.10045.4.3.1", ECDSA_SHA224);
        oidAlgorithms.put("1.2.840.10045.4.3.2", ECDSA_SHA256);
        oidAlgorithms.put("1.2.840.10045.4.3.3", ECDSA_SHA384);
        oidAlgorithms.put("1.2.840.10045.4.3.4", ECDSA_SHA512);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.6", ECDSA_RIPEMD160);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.9", ECDSA_SHA3_224);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.10", ECDSA_SHA3_256);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.11", ECDSA_SHA3_384);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.12", ECDSA_SHA3_512);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.1", PLAIN_ECDSA_SHA1);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.2", PLAIN_ECDSA_SHA224);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.3", PLAIN_ECDSA_SHA256);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.4", PLAIN_ECDSA_SHA384);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.5", PLAIN_ECDSA_SHA512);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.6", PLAIN_ECDSA_RIPEMD160);
        oidAlgorithms.put("1.3.101.112", ED25519);
        oidAlgorithms.put("1.3.101.113", ED448);
        oidAlgorithms.put("1.2.840.10040.4.3", DSA_SHA1);
        oidAlgorithms.put("1.2.14888.3.0.1", DSA_SHA1);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.1", DSA_SHA224);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.2", DSA_SHA256);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.3", DSA_SHA384);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.4", DSA_SHA512);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.5", DSA_SHA3_224);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.6", DSA_SHA3_256);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.7", DSA_SHA3_384);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.8", DSA_SHA3_512);
        oidAlgorithms.put("1.2.840.113549.2.7", HMAC_SHA1);
        oidAlgorithms.put("1.2.840.113549.2.8", HMAC_SHA224);
        oidAlgorithms.put("1.2.840.113549.2.9", HMAC_SHA256);
        oidAlgorithms.put("1.2.840.113549.2.10", HMAC_SHA384);
        oidAlgorithms.put("1.2.840.113549.2.11", HMAC_SHA512);
        oidAlgorithms.put("1.3.6.1.5.5.8.1.4", HMAC_RIPEMD160);
        oidAlgorithms.put("2.16.840.1.101.3.4.2.13", HMAC_SHA3_224);
        oidAlgorithms.put("2.16.840.1.101.3.4.2.14", HMAC_SHA3_256);
        oidAlgorithms.put("2.16.840.1.101.3.4.2.15", HMAC_SHA3_384);
        oidAlgorithms.put("2.16.840.1.101.3.4.2.16", HMAC_SHA3_512);
        oidAlgorithms.put("1.2.840.113549.1.1.10", RSA_SSA_PSS_SHA1_MGF1);
        return oidAlgorithms;
    }

    private static Map<SignatureAlgorithm, String> registerOidAlgorithmsForKey() {
        EnumMap<SignatureAlgorithm, String> oidAlgorithms = new EnumMap<SignatureAlgorithm, String>(SignatureAlgorithm.class);
        for (Map.Entry<String, SignatureAlgorithm> entry : OID_ALGORITHMS.entrySet()) {
            oidAlgorithms.put(entry.getValue(), entry.getKey());
        }
        return oidAlgorithms;
    }

    private static Map<String, SignatureAlgorithm> registerJavaAlgorithms() {
        HashMap<String, SignatureAlgorithm> javaAlgorithms = new HashMap<String, SignatureAlgorithm>();
        javaAlgorithms.put("NONEwithRSA", RSA_RAW);
        javaAlgorithms.put("SHA1withRSA", RSA_SHA1);
        javaAlgorithms.put("SHA224withRSA", RSA_SHA224);
        javaAlgorithms.put("SHA256withRSA", RSA_SHA256);
        javaAlgorithms.put("SHA384withRSA", RSA_SHA384);
        javaAlgorithms.put("SHA512withRSA", RSA_SHA512);
        javaAlgorithms.put("SHA3-224withRSA", RSA_SHA3_224);
        javaAlgorithms.put("SHA3-256withRSA", RSA_SHA3_256);
        javaAlgorithms.put("SHA3-384withRSA", RSA_SHA3_384);
        javaAlgorithms.put("SHA3-512withRSA", RSA_SHA3_512);
        javaAlgorithms.put("NONEwithRSAandMGF1", RSA_SSA_PSS_RAW_MGF1);
        javaAlgorithms.put("SHA1withRSAandMGF1", RSA_SSA_PSS_SHA1_MGF1);
        javaAlgorithms.put("SHA224withRSAandMGF1", RSA_SSA_PSS_SHA224_MGF1);
        javaAlgorithms.put("SHA256withRSAandMGF1", RSA_SSA_PSS_SHA256_MGF1);
        javaAlgorithms.put("SHA384withRSAandMGF1", RSA_SSA_PSS_SHA384_MGF1);
        javaAlgorithms.put("SHA512withRSAandMGF1", RSA_SSA_PSS_SHA512_MGF1);
        javaAlgorithms.put("SHA3-224withRSAandMGF1", RSA_SSA_PSS_SHA3_224_MGF1);
        javaAlgorithms.put("SHA3-256withRSAandMGF1", RSA_SSA_PSS_SHA3_256_MGF1);
        javaAlgorithms.put("SHA3-384withRSAandMGF1", RSA_SSA_PSS_SHA3_384_MGF1);
        javaAlgorithms.put("SHA3-512withRSAandMGF1", RSA_SSA_PSS_SHA3_512_MGF1);
        javaAlgorithms.put("RIPEMD160withRSA", RSA_RIPEMD160);
        javaAlgorithms.put("MD5withRSA", RSA_MD5);
        javaAlgorithms.put("MD2withRSA", RSA_MD2);
        javaAlgorithms.put("NONEwithECDSA", ECDSA_RAW);
        javaAlgorithms.put("SHA1withECDSA", ECDSA_SHA1);
        javaAlgorithms.put("SHA224withECDSA", ECDSA_SHA224);
        javaAlgorithms.put("SHA256withECDSA", ECDSA_SHA256);
        javaAlgorithms.put("SHA384withECDSA", ECDSA_SHA384);
        javaAlgorithms.put("SHA512withECDSA", ECDSA_SHA512);
        javaAlgorithms.put("RIPEMD160withECDSA", ECDSA_RIPEMD160);
        javaAlgorithms.put("SHA1withPLAIN-ECDSA", PLAIN_ECDSA_SHA1);
        javaAlgorithms.put("SHA224withPLAIN-ECDSA", PLAIN_ECDSA_SHA224);
        javaAlgorithms.put("SHA256withPLAIN-ECDSA", PLAIN_ECDSA_SHA256);
        javaAlgorithms.put("SHA384withPLAIN-ECDSA", PLAIN_ECDSA_SHA384);
        javaAlgorithms.put("SHA512withPLAIN-ECDSA", PLAIN_ECDSA_SHA512);
        javaAlgorithms.put("RIPEMD160withPLAIN-ECDSA", PLAIN_ECDSA_RIPEMD160);
        javaAlgorithms.put("SHA3-224withECDSA", ECDSA_SHA3_224);
        javaAlgorithms.put("SHA3-256withECDSA", ECDSA_SHA3_256);
        javaAlgorithms.put("SHA3-384withECDSA", ECDSA_SHA3_384);
        javaAlgorithms.put("SHA3-512withECDSA", ECDSA_SHA3_512);
        javaAlgorithms.put("Ed25519", ED25519);
        javaAlgorithms.put("Ed448", ED448);
        javaAlgorithms.put("NONEwithDSA", DSA_RAW);
        javaAlgorithms.put("SHA1withDSA", DSA_SHA1);
        javaAlgorithms.put("SHA224withDSA", DSA_SHA224);
        javaAlgorithms.put("SHA256withDSA", DSA_SHA256);
        javaAlgorithms.put("SHA384withDSA", DSA_SHA384);
        javaAlgorithms.put("SHA512withDSA", DSA_SHA512);
        javaAlgorithms.put("SHA3-224withDSA", DSA_SHA3_224);
        javaAlgorithms.put("SHA3-256withDSA", DSA_SHA3_256);
        javaAlgorithms.put("SHA3-384withDSA", DSA_SHA3_384);
        javaAlgorithms.put("SHA3-512withDSA", DSA_SHA3_512);
        javaAlgorithms.put("SHA1withHMAC", HMAC_SHA1);
        javaAlgorithms.put("SHA224withHMAC", HMAC_SHA224);
        javaAlgorithms.put("SHA256withHMAC", HMAC_SHA256);
        javaAlgorithms.put("SHA384withHMAC", HMAC_SHA384);
        javaAlgorithms.put("SHA512withHMAC", HMAC_SHA512);
        javaAlgorithms.put("SHA3-224withHMAC", HMAC_SHA3_224);
        javaAlgorithms.put("SHA3-256withHMAC", HMAC_SHA3_256);
        javaAlgorithms.put("SHA3-384withHMAC", HMAC_SHA3_384);
        javaAlgorithms.put("SHA3-512withHMAC", HMAC_SHA3_512);
        javaAlgorithms.put("RIPEMD160withHMAC", HMAC_RIPEMD160);
        return javaAlgorithms;
    }

    private static Map<SignatureAlgorithm, String> registerJavaAlgorithmsForKey() {
        EnumMap<SignatureAlgorithm, String> javaAlgorithms = new EnumMap<SignatureAlgorithm, String>(SignatureAlgorithm.class);
        for (Map.Entry<String, SignatureAlgorithm> entry : JAVA_ALGORITHMS.entrySet()) {
            javaAlgorithms.put(entry.getValue(), entry.getKey());
        }
        return javaAlgorithms;
    }

    public static SignatureAlgorithm forXML(String xmlName) {
        SignatureAlgorithm algorithm = XML_ALGORITHMS.get(xmlName);
        if (algorithm == null) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_ALGO_MSG, xmlName));
        }
        return algorithm;
    }

    public static SignatureAlgorithm forXML(String xmlName, SignatureAlgorithm defaultValue) {
        SignatureAlgorithm algorithm = XML_ALGORITHMS.get(xmlName);
        if (algorithm == null) {
            return defaultValue;
        }
        return algorithm;
    }

    public static SignatureAlgorithm forOID(String oid) {
        return SignatureAlgorithm.forOidAndParams(oid, null);
    }

    public static SignatureAlgorithm forOidAndParams(String oid, byte[] sigAlgParams) {
        SignatureAlgorithm algorithm = OID_ALGORITHMS.get(oid);
        if (algorithm == null) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_ALGO_MSG, oid));
        }
        if (sigAlgParams != null && algorithm.getMaskGenerationFunction() != null) {
            try {
                AlgorithmParameters algoParams = AlgorithmParameters.getInstance("PSS");
                algoParams.init(sigAlgParams);
                PSSParameterSpec pssParam = algoParams.getParameterSpec(PSSParameterSpec.class);
                DigestAlgorithm digestAlgorithm = DigestAlgorithm.forJavaName(pssParam.getDigestAlgorithm());
                algorithm = SignatureAlgorithm.getAlgorithm(algorithm.getEncryptionAlgorithm(), digestAlgorithm, algorithm.getMaskGenerationFunction());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Unable to initialize PSS", e);
            }
        }
        return algorithm;
    }

    public static SignatureAlgorithm forJAVA(String javaName) {
        SignatureAlgorithm algorithm = JAVA_ALGORITHMS.get(javaName);
        if (algorithm == null) {
            throw new IllegalArgumentException(String.format(UNSUPPORTED_ALGO_MSG, javaName));
        }
        return algorithm;
    }

    public static SignatureAlgorithm getAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        return SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, null);
    }

    public static SignatureAlgorithm getAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, MaskGenerationFunction mgf) {
        for (SignatureAlgorithm currentAlgo : SignatureAlgorithm.values()) {
            if (!Objects.equals(currentAlgo.getEncryptionAlgorithm(), encryptionAlgorithm) || !Objects.equals(currentAlgo.getDigestAlgorithm(), digestAlgorithm) || !Objects.equals((Object)currentAlgo.getMaskGenerationFunction(), (Object)mgf)) continue;
            return currentAlgo;
        }
        return null;
    }

    private SignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        this.encryptionAlgo = encryptionAlgorithm;
        this.digestAlgo = digestAlgorithm;
        this.maskGenerationFunction = null;
    }

    private SignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, MaskGenerationFunction maskGenerationFunction) {
        this.encryptionAlgo = encryptionAlgorithm;
        this.digestAlgo = digestAlgorithm;
        this.maskGenerationFunction = maskGenerationFunction;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgo;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public MaskGenerationFunction getMaskGenerationFunction() {
        return this.maskGenerationFunction;
    }

    @Override
    public String getUri() {
        return XML_ALGORITHMS_FOR_KEY.get(this);
    }

    @Override
    public String getOid() {
        return OID_ALGORITHMS_FOR_KEY.get(this);
    }

    public String getURIBasedOnOID() {
        return OID_NAMESPACE_PREFIX + this.getOid();
    }

    public String getJCEId() {
        return JAVA_ALGORITHMS_FOR_KEY.get(this);
    }

    static {
        XML_ALGORITHMS = SignatureAlgorithm.registerXmlAlgorithms();
        XML_ALGORITHMS_FOR_KEY = SignatureAlgorithm.registerXmlAlgorithmsForKey();
        OID_ALGORITHMS = SignatureAlgorithm.registerOIDAlgorithms();
        OID_ALGORITHMS_FOR_KEY = SignatureAlgorithm.registerOidAlgorithmsForKey();
        JAVA_ALGORITHMS = SignatureAlgorithm.registerJavaAlgorithms();
        JAVA_ALGORITHMS_FOR_KEY = SignatureAlgorithm.registerJavaAlgorithmsForKey();
    }
}

