/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature.asics;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class AbstractGetDataToSignASiCS {
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file-";

    /*
     * Enabled aggressive exception aggregation
     */
    protected DSSDocument createPackageZip(List<DSSDocument> documents, Date signingDate) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            InMemoryDocument inMemoryDocument;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (int i = 0; i < documents.size(); ++i) {
                    DSSDocument document = documents.get(i);
                    String documentName = document.getName();
                    String name = documentName != null ? documentName : ZIP_ENTRY_DETACHED_FILE + i;
                    ZipEntry entryDocument = new ZipEntry(name);
                    entryDocument.setTime(signingDate.getTime());
                    entryDocument.setMethod(0);
                    byte[] byteArray = DSSUtils.toByteArray(document);
                    entryDocument.setSize(byteArray.length);
                    entryDocument.setCompressedSize(byteArray.length);
                    CRC32 crc = new CRC32();
                    crc.update(byteArray);
                    entryDocument.setCrc(crc.getValue());
                    zos.putNextEntry(entryDocument);
                    Utils.write(byteArray, zos);
                }
                zos.finish();
                inMemoryDocument = new InMemoryDocument(baos.toByteArray(), "package.zip");
            }
            return inMemoryDocument;
        }
        catch (IOException e) {
            throw new DSSException("Unable to create package.zip file", e);
        }
    }
}

